/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.internal.dataweave;

import com.mulesoft.connectivity.linkweave.internal.dataweave.ArrayGetItemExpression;
import com.mulesoft.connectivity.linkweave.internal.dataweave.Converters;
import com.mulesoft.connectivity.linkweave.internal.dataweave.FieldSelectionExpression;
import com.mulesoft.connectivity.linkweave.internal.dataweave.ItemExistsInArrayExpression;
import com.mulesoft.connectivity.linkweave.internal.dataweave.SizeOfArrayExpression;
import com.mulesoft.connectivity.linkweave.internal.dataweave.VariableExpression;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.runtime.BindingValue;
import org.mule.weave.v2.runtime.DataWeaveValue;
import org.mule.weave.v2.runtime.ExecuteResult;
import org.mule.weave.v2.runtime.ScriptingBindings;
import scala.collection.JavaConverters;
import scala.collection.Map;

public abstract class Expression {
    private static final Pattern REGEX = Pattern.compile("^[a-zA-Z]\\w*+(?:\\[i]\\??+)?(?:\\.[a-zA-Z]\\w*+(?:\\[i]\\??+)?)*+$");
    private static final Pattern SIZEOF_REGEX = Pattern.compile("^sizeOf\\((.*)\\)$");

    abstract @Nullable DataWeaveValue evaluate(Function<String, @Nullable DataWeaveValue> var1);

    public @Nullable Object toJava(ScriptingBindings bindings, java.util.Map<String, ExecuteResult> boundExecuteResults) {
        return this.toJava(name -> Expression.resolve(name, bindings, boundExecuteResults));
    }

    @Nullable Object toJava(Function<String, @Nullable DataWeaveValue> bindings) {
        return Converters.toJava(this.evaluate(bindings));
    }

    private static DataWeaveValue resolve(String name, ScriptingBindings bindings, java.util.Map<String, ExecuteResult> boundExecuteResults) {
        Object v;
        ExecuteResult executeResult = boundExecuteResults.get(name);
        if (executeResult != null) {
            return executeResult.asDWValue();
        }
        BindingValue bv = (BindingValue)JavaConverters.mapAsJavaMap((Map)bindings.bindings()).get(name);
        Object object = v = bv == null ? null : bv.value();
        if (v instanceof Number) {
            Number num = (Number)v;
            return Converters.toDataWeaveValue(num);
        }
        if (v != null) {
            throw new IllegalArgumentException("Unknown variable type " + String.valueOf(v));
        }
        throw new IllegalArgumentException("Unknown variable: " + name);
    }

    public static boolean supported(String script) {
        script = SIZEOF_REGEX.matcher(script).replaceAll("$1");
        return REGEX.matcher(script).matches();
    }

    public static Expression compile(String script) {
        String[] parts;
        String str = SIZEOF_REGEX.matcher(script).replaceAll("$1");
        boolean sizeOf = !str.equals(script);
        script = str;
        Expression exp = null;
        for (String part : parts = script.split("\\.")) {
            exp = Expression.addSelectionPartToExpression(part, exp);
        }
        Objects.requireNonNull(exp, "empty expression");
        return sizeOf ? new SizeOfArrayExpression(exp) : exp;
    }

    private static Expression addSelectionPartToExpression(String part, @Nullable Expression exp) {
        int p = part.indexOf(91);
        if (p != -1) {
            int q = part.indexOf(93, p);
            String variable = part.substring(p + 1, q);
            String left = part.substring(0, p);
            Expression leftExpression = exp == null ? new VariableExpression(left) : new FieldSelectionExpression(exp, left);
            VariableExpression subindexExpression = new VariableExpression(variable);
            if (q + 1 < part.length() && part.charAt(q + 1) == '?') {
                return new ItemExistsInArrayExpression(leftExpression, subindexExpression);
            }
            return new ArrayGetItemExpression(leftExpression, subindexExpression);
        }
        return exp == null ? new VariableExpression(part) : new FieldSelectionExpression(exp, part);
    }
}

