/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.loader;

import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.matchers.ObjectFieldMatcher;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.linkweave.api.model.value.Holder;
import com.mulesoft.connectivity.linkweave.test.TestUtils;
import com.mulesoft.connectivity.mule.internal.loader.MuleConnectorLoader;
import com.mulesoft.connectivity.mule.internal.loader.MuleConnectorLoaderFactory;
import com.mulesoft.connectivity.mule.internal.loader.MuleModelLoader;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectionProviderModel;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectorModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.jspecify.annotations.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.meta.Category;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.mule.weave.v2.parser.phase.CompilationException;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.AnyType;
import org.mule.weave.v2.ts.BinaryType;
import org.mule.weave.v2.ts.TypeParameter;

public class MuleConnectorLoaderTest {
    private static final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();
    private static final MuleConnectorLoader muleConnectorLoader = new MuleConnectorLoaderFactory().create();
    private static final LanguageModelLoader<@NonNull MuleConnectorModel, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MuleConnectorModel.Builder> muleLoader = new MuleModelLoader(dataWeaveEngine);

    @Test
    void testConnectorModelLoadingWithDescriptorAndConnectionAndOperationAndTrigger() {
        MuleConnectorModel connectorModel = (MuleConnectorModel)muleLoader.loadModule("pulseConnector::Connector");
        this.assertMuleConnectorModel(connectorModel);
    }

    @Test
    void testConnectorModelLoadingWithInvalidCategory() {
        RuntimeException runtimeException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> muleLoader.loadModule("pulseConnectorWithInvalidCategory::Connector"));
        MatcherAssert.assertThat((Object)runtimeException.getCause().getMessage(), (Matcher)Matchers.is((Object)"No enum constant org.mule.runtime.api.meta.Category.INVALID"));
    }

    @Test
    void testConnectorModelLoadingWithInvalidModuleReference() {
        CompilationException compilationException = (CompilationException)Assertions.assertThrows(CompilationException.class, () -> muleLoader.loadModule("pulseConnectorWithInvalidPath::Connector"));
        MatcherAssert.assertThat((Object)compilationException, (Matcher)Matchers.anything((String)"Unable to resolve module with identifier pulseConnectorWithInvalidPath::Connector."));
    }

    @Test
    void testConfigureBuilderInvalidTypeMuleConnectorLoader() {
        IllegalStateException illegalStateException = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> muleConnectorLoader.configureBuilder(new MuleConnectorModel.Builder(), new DataWeaveObjectReference("pulseConnector::Connector::connector", (DWType)new AnyType(), new HashMap()), null));
        MatcherAssert.assertThat((Object)illegalStateException.getMessage(), (Matcher)Matchers.is((Object)"Invalid connector type. Expected Object but Any found"));
    }

    private void assertMuleConnectorModel(MuleConnectorModel connectorModel) {
        MatcherAssert.assertThat((Object)connectorModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectorModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"pulseConnector::Connector::connector"));
        MatcherAssert.assertThat((Object)connectorModel.getName(), (Matcher)Matchers.equalTo((Object)"PULSE"));
        MatcherAssert.assertThat((Object)connectorModel.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Pulse Connector"));
        MatcherAssert.assertThat((Object)connectorModel.getDescription(), (Matcher)Matchers.equalTo((Object)"Pulse Connector to test the IC Mule Extension"));
        MatcherAssert.assertThat((Object)connectorModel.getVendor(), (Matcher)Matchers.equalTo((Object)"Salesforce"));
        MatcherAssert.assertThat((Object)connectorModel.getVersion(), (Matcher)Matchers.equalTo((Object)"1.2.3"));
        MatcherAssert.assertThat((Object)connectorModel.getCategory(), (Matcher)Matchers.equalTo((Object)Category.COMMUNITY));
        this.assertConnections(connectorModel);
        this.assertTestConnection(connectorModel.getTestConnection());
        this.assertOperations(connectorModel.getOperations());
        this.assertValueProviders(connectorModel.getValueProviders());
        this.assertTriggers(connectorModel.getTriggers());
    }

    private void assertOperations(List<OperationModel> operations) {
        MatcherAssert.assertThat(operations, (Matcher)Matchers.hasSize((int)11));
        this.assertGetRecordsOperation(operations.get(0));
        this.assertGetRecordByIdOperation(operations.get(1));
        this.assertCreateRecordOperation(operations.get(2));
        this.assertGetOffsetPaginatedOperation(operations.get(3));
        this.assertGetPageNumberPaginatedOperation(operations.get(4));
        this.assertGetHypermediaPaginatedOperation(operations.get(5));
        this.assertGetMarkerPaginatedOperation(operations.get(6));
        this.assertGetRecordByIdVPWithParam(operations.get(9));
    }

    private void assertTriggers(List<TriggerModel> triggers) {
        MatcherAssert.assertThat(triggers, (Matcher)Matchers.hasSize((int)2));
        this.assertPaginatedTrigger(triggers.get(0));
        this.assertNonPaginatedTrigger(triggers.get(1));
    }

    private void assertPaginatedTrigger(TriggerModel triggerModel) {
        this.assertModelReference((ExecutableComponentModel<?>)triggerModel, "pulseConnector::Connector::connector.triggers.paginatedTrigger");
        this.assertTriggerInputAndOutputType(triggerModel);
        MatcherAssert.assertThat((Object)triggerModel.isPaginated(), (Matcher)Matchers.is((Object)true));
        this.assertTriggerOutputResolvedProviders(triggerModel);
    }

    private void assertNonPaginatedTrigger(TriggerModel triggerModel) {
        this.assertModelReference((ExecutableComponentModel<?>)triggerModel, "pulseConnector::Connector::connector.triggers.nonPaginatedTrigger");
        this.assertTriggerInputAndOutputType(triggerModel);
        MatcherAssert.assertThat((Object)triggerModel.isPaginated(), (Matcher)Matchers.is((Object)false));
        this.assertTriggerOutputResolvedProviders(triggerModel);
    }

    private void assertTriggerInputAndOutputType(TriggerModel triggerModel) {
        Assertions.assertNotNull((Object)triggerModel.getInputType());
        Assertions.assertNotNull((Object)triggerModel.getInputType().getDataType());
        ObjectType inputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)triggerModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"itemsPerPage", NumberType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"itemsPerPoll", NumberType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"totalItems", NumberType.class, (boolean)true)}));
        Assertions.assertNotNull((Object)triggerModel.getOutputType());
        Assertions.assertNotNull((Object)triggerModel.getOutputType().getDataType());
        ObjectType outputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)triggerModel.getOutputType().getDataType());
        MatcherAssert.assertThat(List.of(outputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"pollID", NumberType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"pageID", NumberType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"pageLocalID", NumberType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"pollLocalID", NumberType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"globalID", NumberType.class, (boolean)true)}));
    }

    private void assertValueProviders(List<ValueProviderModel> valueProviders) {
        MatcherAssert.assertThat(valueProviders, (Matcher)Matchers.hasSize((int)4));
        this.assertRecordValueProviderParam(valueProviders.get(0));
        this.assertRecordValueProvider(valueProviders.get(1));
        this.assertPaginatedValueProvider(valueProviders.get(2));
    }

    private void assertRecordValueProviderParam(ValueProviderModel valueProviderModel) {
        Assertions.assertNotNull((Object)valueProviderModel);
        MatcherAssert.assertThat((Object)valueProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)valueProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"pulseConnector::Connector::connector.valueProviders.recordValueProviderParam"));
        MatcherAssert.assertThat((Object)valueProviderModel.isPaginated(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)valueProviderModel.getName(), (Matcher)Matchers.is((Object)"recordValueProviderParam"));
        MatcherAssert.assertThat((Object)(valueProviderModel.getInputType().getDataType() instanceof ObjectType), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(List.of(((ObjectType)valueProviderModel.getInputType().getDataType()).getProperties()), (Matcher)Matchers.contains((Matcher)ObjectFieldMatcher.fieldLike((String)"state", StringType.class, (boolean)true)));
        Assertions.assertNotNull((Object)valueProviderModel.getProvidedValueType());
        Assertions.assertNotNull((Object)valueProviderModel.getDisplayPropertiesType());
        MatcherAssert.assertThat((Object)(valueProviderModel.getDisplayPropertiesType().getDataType() instanceof ObjectType), (Matcher)Matchers.is((Object)true));
    }

    private void assertPaginatedValueProvider(ValueProviderModel valueProviderModel) {
        Assertions.assertNotNull((Object)valueProviderModel);
        MatcherAssert.assertThat((Object)valueProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)valueProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"pulseConnector::Connector::connector.valueProviders.paginatedValueProvider"));
        Assertions.assertNotNull((Object)valueProviderModel.getInputType());
        Assertions.assertNotNull((Object)valueProviderModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(((ObjectType)valueProviderModel.getInputType().getDataType()).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"page", NumberType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"limit", NumberType.class, (boolean)true)}));
        MatcherAssert.assertThat((Object)valueProviderModel.isPaginated(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)valueProviderModel.getName(), (Matcher)Matchers.is((Object)"paginatedValueProvider"));
        Assertions.assertNotNull((Object)valueProviderModel.getProvidedValueType());
    }

    private void assertRecordValueProvider(ValueProviderModel valueProviderModel) {
        Assertions.assertNotNull((Object)valueProviderModel);
        MatcherAssert.assertThat((Object)valueProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)valueProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"pulseConnector::Connector::connector.valueProviders.recordValueProvider"));
        Assertions.assertNotNull((Object)valueProviderModel.getInputType());
        Assertions.assertNotNull((Object)valueProviderModel.getInputType().getDataType());
        MatcherAssert.assertThat((Object)valueProviderModel.isPaginated(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)valueProviderModel.getName(), (Matcher)Matchers.is((Object)"recordValueProvider"));
        MatcherAssert.assertThat((Object)(valueProviderModel.getInputType().getDataType() instanceof TypeParameter), (Matcher)Matchers.is((Object)true));
        Assertions.assertNotNull((Object)valueProviderModel.getProvidedValueType());
        Assertions.assertNotNull((Object)valueProviderModel.getDisplayPropertiesType());
        MatcherAssert.assertThat((Object)(valueProviderModel.getDisplayPropertiesType().getDataType() instanceof ObjectType), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(List.of(((ObjectType)valueProviderModel.getDisplayPropertiesType().getDataType()).getProperties()), (Matcher)Matchers.contains((Matcher)ObjectFieldMatcher.fieldLike((String)"helpText", StringType.class, (boolean)true)));
    }

    private void assertModelReference(ExecutableComponentModel<?> model, String expectedReference) {
        Assertions.assertNotNull(model);
        MatcherAssert.assertThat((Object)model.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)model.getModelReference().get()), (Matcher)Matchers.equalTo((Object)expectedReference));
    }

    private void assertErrorOutputType(ExecutableComponentModel<?> model) {
        ObjectType errorOutputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)model.getErrorOutputType().getDataType());
        MatcherAssert.assertThat((Object)errorOutputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        errorOutputType = (ObjectType)TypeUtils.getProperty((ObjectType)errorOutputType, (String)"error");
        MatcherAssert.assertThat(List.of(errorOutputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"categories", UnionType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"description", UnionType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"kind", UnionType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"value", DWType.class, (boolean)true)}));
        DWType valueType = TypeUtils.getProperty((ObjectType)errorOutputType, (String)"value");
        DWType simplifiedValue = WeaveTypeSimplifier.simplifyWeaveType((DWType)valueType);
        MatcherAssert.assertThat(List.of(((ObjectType)simplifiedValue).getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"rawBody", BinaryType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"contentType", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"attributes", ObjectType.class, (boolean)true)}));
    }

    private void assertGetRecordsOperation(OperationModel operationModel) {
        this.assertModelReference((ExecutableComponentModel<?>)operationModel, "pulseConnector::Connector::connector.operations.getRecords");
        Assertions.assertNotNull((Object)operationModel.getInputType());
        Assertions.assertNotNull((Object)operationModel.getInputType().getDataType());
        ObjectType inputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"customHeaders", ObjectType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"customQueryParams", ObjectType.class, (boolean)false)}));
        Assertions.assertNotNull((Object)operationModel.getOutputType());
        Assertions.assertNotNull((Object)operationModel.getOutputType().getDataType());
        DWType outputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getOutputType().getDataType());
        ObjectType httpResponseType = (ObjectType)outputType;
        MatcherAssert.assertThat(List.of(httpResponseType.getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"body", DWType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"rawBody", BinaryType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"contentType", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"attributes", ObjectType.class, (boolean)true)}));
        DWType bodyDwType = TypeUtils.getProperty((ObjectType)httpResponseType, (String)"body");
        DWType simplifiedBodyType = WeaveTypeSimplifier.simplifyWeaveType((DWType)bodyDwType);
        DWType elementType = WeaveTypeSimplifier.simplifyWeaveType((DWType)((ArrayType)simplifiedBodyType).arrayOf());
        if (elementType instanceof ObjectType) {
            ObjectType objType = (ObjectType)elementType;
            this.assertRecordObjectType(objType);
        } else {
            MatcherAssert.assertThat((Object)elementType, (Matcher)IsInstanceOf.instanceOf(AnyType.class));
        }
        this.assertErrorOutputType((ExecutableComponentModel<?>)operationModel);
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.is((Object)false));
    }

    private void assertGetRecordByIdOperation(OperationModel operationModel) {
        this.assertModelReference((ExecutableComponentModel<?>)operationModel, "pulseConnector::Connector::connector.operations.getRecordById");
        Assertions.assertNotNull((Object)operationModel.getInputType());
        Assertions.assertNotNull((Object)operationModel.getInputType().getDataType());
        ObjectType inputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"recordId", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"recordName", StringType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"header1", StringType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"query1", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"query2", StringType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"customHeaders", ObjectType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"customQueryParams", ObjectType.class, (boolean)false)}));
        Assertions.assertNotNull((Object)operationModel.getOutputType());
        Assertions.assertNotNull((Object)operationModel.getOutputType().getDataType());
        DWType outputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getOutputType().getDataType());
        ObjectType httpResponseType = (ObjectType)outputType;
        MatcherAssert.assertThat(List.of(httpResponseType.getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"body", DWType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"rawBody", BinaryType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"contentType", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"attributes", ObjectType.class, (boolean)true)}));
        DWType bodyDwType = TypeUtils.getProperty((ObjectType)httpResponseType, (String)"body");
        DWType simplifiedRecordType = WeaveTypeSimplifier.simplifyWeaveType((DWType)bodyDwType);
        this.assertRecordObjectType((ObjectType)simplifiedRecordType);
        this.assertErrorOutputType((ExecutableComponentModel<?>)operationModel);
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.is((Object)false));
        this.assertOutputResolvedProviders(operationModel);
    }

    private void assertInputResolvedProviders(OperationModel operationModel) {
        Map inputResolvedProviders = operationModel.getInputResolvedProviders();
        MatcherAssert.assertThat((Object)inputResolvedProviders, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)inputResolvedProviders.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        ObjectFieldSelector recordIdFieldSelector = ObjectFieldSelector.create((String)"/recordId");
        ExecutableComponentModel.ProviderReferences providerReferences = (ExecutableComponentModel.ProviderReferences)inputResolvedProviders.get(recordIdFieldSelector);
        MatcherAssert.assertThat((Object)providerReferences, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ProviderReference valueProviderReference = providerReferences.getValueProviderReference();
        MatcherAssert.assertThat((Object)valueProviderReference, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)valueProviderReference.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"recordValueProvider")));
        MatcherAssert.assertThat((Object)valueProviderReference.getArguments(), (Matcher)Matchers.hasSize((int)0));
        Optional valueProviderRef = operationModel.getValueProviderReferenceFor("/recordId");
        MatcherAssert.assertThat((Object)valueProviderRef.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ProviderReference)valueProviderRef.get()).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"recordValueProvider")));
        MatcherAssert.assertThat((Object)((ProviderReference)valueProviderRef.get()).getArguments(), (Matcher)Matchers.hasSize((int)0));
    }

    private void assertGetRecordByIdVPWithParam(OperationModel operationModel) {
        this.assertModelReference((ExecutableComponentModel<?>)operationModel, "pulseConnector::Connector::connector.operations.getRecordByIdVPWithParam");
        Assertions.assertNotNull((Object)operationModel.getInputType());
        Assertions.assertNotNull((Object)operationModel.getInputType().getDataType());
        ObjectType inputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"recordId", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"province", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"country", ObjectType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"recordIdWithContextRef", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"recordIdWithRelativePath", StringType.class, (boolean)true)}));
        Assertions.assertNotNull((Object)operationModel.getOutputType());
        Assertions.assertNotNull((Object)operationModel.getOutputType().getDataType());
        DWType outputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getOutputType().getDataType());
        ObjectType httpResponseType = (ObjectType)outputType;
        MatcherAssert.assertThat(List.of(httpResponseType.getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"body", DWType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"rawBody", BinaryType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"contentType", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"attributes", ObjectType.class, (boolean)true)}));
        DWType bodyDwType = TypeUtils.getProperty((ObjectType)httpResponseType, (String)"body");
        DWType simplifiedRecordType = WeaveTypeSimplifier.simplifyWeaveType((DWType)bodyDwType);
        this.assertRecordObjectType((ObjectType)simplifiedRecordType);
        this.assertErrorOutputType((ExecutableComponentModel<?>)operationModel);
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.is((Object)false));
        this.assertInputResolvedProvidersWithParam(operationModel);
        this.assertOutputResolvedProvidersWithParam(operationModel);
    }

    private void assertInputResolvedProvidersWithParam(OperationModel operationModel) {
        Map inputResolvedProviders = operationModel.getInputResolvedProviders();
        MatcherAssert.assertThat((Object)inputResolvedProviders, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)inputResolvedProviders.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)3)));
        ObjectFieldSelector recordIdFieldSelector = ObjectFieldSelector.create((String)"/recordId");
        ExecutableComponentModel.ProviderReferences providerReferences = (ExecutableComponentModel.ProviderReferences)inputResolvedProviders.get(recordIdFieldSelector);
        MatcherAssert.assertThat((Object)providerReferences, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ProviderReference valueProviderReference = providerReferences.getValueProviderReference();
        MatcherAssert.assertThat((Object)valueProviderReference, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)valueProviderReference.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"recordValueProviderParam")));
        MatcherAssert.assertThat((Object)valueProviderReference.getArguments(), (Matcher)Matchers.hasSize((int)1));
        ProviderArgument argument = (ProviderArgument)valueProviderReference.getArguments().get(0);
        MatcherAssert.assertThat((Object)argument.getParameterSelector().toString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"state")));
        MatcherAssert.assertThat((Object)argument.getInputSelector().toString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"/country/province")));
        ObjectFieldSelector recordIdWithContextRefSelector = ObjectFieldSelector.create((String)"/recordIdWithContextRef");
        ExecutableComponentModel.ProviderReferences providerReferencesWithContextRef = (ExecutableComponentModel.ProviderReferences)inputResolvedProviders.get(recordIdWithContextRefSelector);
        MatcherAssert.assertThat((Object)providerReferencesWithContextRef, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ProviderReference valueProviderReferenceWithContextRef = providerReferencesWithContextRef.getValueProviderReference();
        MatcherAssert.assertThat((Object)valueProviderReferenceWithContextRef, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)valueProviderReferenceWithContextRef.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"recordValueProviderParam")));
        MatcherAssert.assertThat((Object)valueProviderReferenceWithContextRef.getArguments(), (Matcher)Matchers.hasSize((int)1));
        ProviderArgument argumentWithContextRef = (ProviderArgument)valueProviderReferenceWithContextRef.getArguments().get(0);
        MatcherAssert.assertThat((Object)argumentWithContextRef.getParameterSelector().toString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"state")));
        MatcherAssert.assertThat((Object)argumentWithContextRef.getInputSelector().toString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"/province")));
        ObjectFieldSelector recordIdWithRelativePathSelector = ObjectFieldSelector.create((String)"/recordIdWithRelativePath");
        ExecutableComponentModel.ProviderReferences providerReferencesWithRelativePath = (ExecutableComponentModel.ProviderReferences)inputResolvedProviders.get(recordIdWithRelativePathSelector);
        MatcherAssert.assertThat((Object)providerReferencesWithRelativePath, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ProviderReference valueProviderReferenceWithRelativePath = providerReferencesWithRelativePath.getValueProviderReference();
        MatcherAssert.assertThat((Object)valueProviderReferenceWithRelativePath, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)valueProviderReferenceWithRelativePath.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"recordValueProviderParam")));
        MatcherAssert.assertThat((Object)valueProviderReferenceWithRelativePath.getArguments(), (Matcher)Matchers.hasSize((int)1));
        ProviderArgument argumentWithRelativePath = (ProviderArgument)valueProviderReferenceWithRelativePath.getArguments().get(0);
        MatcherAssert.assertThat((Object)argumentWithRelativePath.getParameterSelector().toString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"state")));
        MatcherAssert.assertThat((Object)argumentWithRelativePath.getInputSelector().toString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"/province")));
        Optional valueProviderRef = operationModel.getValueProviderReferenceFor("/recordId");
        MatcherAssert.assertThat((Object)valueProviderRef.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ProviderReference)valueProviderRef.get()).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"recordValueProviderParam")));
        MatcherAssert.assertThat((Object)((ProviderReference)valueProviderRef.get()).getArguments(), (Matcher)Matchers.hasSize((int)1));
        Optional metadataProviderRef = operationModel.getInputMetadataProviderReferenceFor("/recordId");
        MatcherAssert.assertThat((Object)metadataProviderRef.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    private void assertOutputResolvedProviders(OperationModel operationModel) {
        Map outputResolvedProviders = operationModel.getOutputResolvedProviders();
        MatcherAssert.assertThat((Object)outputResolvedProviders, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)outputResolvedProviders.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)outputResolvedProviders, (Matcher)IsInstanceOf.instanceOf(Map.class));
    }

    private void assertOutputResolvedProvidersWithParam(OperationModel operationModel) {
        Map outputResolvedProviders = operationModel.getOutputResolvedProviders();
        MatcherAssert.assertThat((Object)outputResolvedProviders, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)outputResolvedProviders.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)outputResolvedProviders, (Matcher)IsInstanceOf.instanceOf(Map.class));
    }

    private void assertTriggerOutputResolvedProviders(TriggerModel triggerModel) {
        Map outputResolvedProviders = triggerModel.getOutputResolvedProviders();
        MatcherAssert.assertThat((Object)outputResolvedProviders, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)outputResolvedProviders.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)outputResolvedProviders, (Matcher)IsInstanceOf.instanceOf(Map.class));
    }

    private void assertCreateRecordOperation(OperationModel operationModel) {
        this.assertModelReference((ExecutableComponentModel<?>)operationModel, "pulseConnector::Connector::connector.operations.createRecord");
        Assertions.assertNotNull((Object)operationModel.getInputType());
        Assertions.assertNotNull((Object)operationModel.getInputType().getDataType());
        ObjectType inputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"record", ObjectType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"customHeaders", ObjectType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"customQueryParams", ObjectType.class, (boolean)false)}));
        DWType recordField = TypeUtils.getProperty((ObjectType)inputType, (String)"record");
        MatcherAssert.assertThat((Object)recordField, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        ObjectType recordType = (ObjectType)recordField;
        this.assertRecordObjectType(recordType);
        Assertions.assertNotNull((Object)operationModel.getOutputType());
        Assertions.assertNotNull((Object)operationModel.getOutputType().getDataType());
        DWType outputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getOutputType().getDataType());
        ObjectType httpResponseType = (ObjectType)outputType;
        MatcherAssert.assertThat(List.of(httpResponseType.getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"body", DWType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"rawBody", BinaryType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"contentType", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"attributes", ObjectType.class, (boolean)true)}));
        DWType bodyDwType = TypeUtils.getProperty((ObjectType)httpResponseType, (String)"body");
        DWType simplifiedRespType = WeaveTypeSimplifier.simplifyWeaveType((DWType)bodyDwType);
        this.assertRecordObjectType((ObjectType)simplifiedRespType);
        this.assertErrorOutputType((ExecutableComponentModel<?>)operationModel);
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.is((Object)false));
        this.assertOutputResolvedProviders(operationModel);
    }

    private void assertGetOffsetPaginatedOperation(OperationModel operationModel) {
        this.assertModelReference((ExecutableComponentModel<?>)operationModel, "pulseConnector::Connector::connector.operations.getOffsetPaginated");
        Assertions.assertNotNull((Object)operationModel.getInputType());
        Assertions.assertNotNull((Object)operationModel.getInputType().getDataType());
        ObjectType inputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"from", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"limit", StringType.class, (boolean)true)}));
        Assertions.assertNotNull((Object)operationModel.getOutputType());
        Assertions.assertNotNull((Object)operationModel.getOutputType().getDataType());
        DWType outputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getOutputType().getDataType());
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ArrayType.class));
        ArrayType arrayType = (ArrayType)outputType;
        ObjectType itemType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)arrayType.arrayOf());
        this.assertPaginationItemObjectType(itemType);
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.is((Object)true));
    }

    private void assertGetPageNumberPaginatedOperation(OperationModel operationModel) {
        this.assertModelReference((ExecutableComponentModel<?>)operationModel, "pulseConnector::Connector::connector.operations.getPageNumberPaginated");
        Assertions.assertNotNull((Object)operationModel.getInputType());
        Assertions.assertNotNull((Object)operationModel.getInputType().getDataType());
        ObjectType inputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"page", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"limit", StringType.class, (boolean)true)}));
        Assertions.assertNotNull((Object)operationModel.getOutputType());
        Assertions.assertNotNull((Object)operationModel.getOutputType().getDataType());
        DWType outputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getOutputType().getDataType());
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ArrayType.class));
        ArrayType arrayType = (ArrayType)outputType;
        ObjectType itemType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)arrayType.arrayOf());
        this.assertPaginationItemObjectType(itemType);
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.is((Object)true));
    }

    private void assertGetMarkerPaginatedOperation(OperationModel operationModel) {
        this.assertModelReference((ExecutableComponentModel<?>)operationModel, "pulseConnector::Connector::connector.operations.getMarkerPaginated");
        Assertions.assertNotNull((Object)operationModel.getInputType());
        Assertions.assertNotNull((Object)operationModel.getInputType().getDataType());
        ObjectType inputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"markerToken", StringType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"limit", StringType.class, (boolean)true)}));
        Assertions.assertNotNull((Object)operationModel.getOutputType());
        Assertions.assertNotNull((Object)operationModel.getOutputType().getDataType());
        DWType outputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getOutputType().getDataType());
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ArrayType.class));
        ArrayType arrayType = (ArrayType)outputType;
        ObjectType itemType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)arrayType.arrayOf());
        this.assertPaginationItemObjectType(itemType);
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.is((Object)true));
    }

    private void assertGetHypermediaPaginatedOperation(OperationModel operationModel) {
        this.assertModelReference((ExecutableComponentModel<?>)operationModel, "pulseConnector::Connector::connector.operations.getHypermediaPaginated");
        Assertions.assertNotNull((Object)operationModel.getInputType());
        Assertions.assertNotNull((Object)operationModel.getInputType().getDataType());
        ObjectType inputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"pageMarker", StringType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"limit", StringType.class, (boolean)false)}));
        Assertions.assertNotNull((Object)operationModel.getOutputType());
        Assertions.assertNotNull((Object)operationModel.getOutputType().getDataType());
        DWType outputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)operationModel.getOutputType().getDataType());
        MatcherAssert.assertThat((Object)outputType, (Matcher)IsInstanceOf.instanceOf(ArrayType.class));
        ArrayType arrayType = (ArrayType)outputType;
        ObjectType itemType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)arrayType.arrayOf());
        this.assertPaginationItemObjectType(itemType);
        MatcherAssert.assertThat((Object)operationModel.isPaginated(), (Matcher)Matchers.is((Object)true));
    }

    private void assertPaginationItemObjectType(ObjectType paginationItemType) {
        MatcherAssert.assertThat(List.of(paginationItemType.getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"id", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"name", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"email", StringType.class, (boolean)true)}));
    }

    private void assertConnections(MuleConnectorModel connectorModel) {
        MatcherAssert.assertThat((Object)connectorModel.getConnections(), (Matcher)Matchers.hasSize((int)5));
        this.assertBasicConnection(connectorModel);
        this.assertBearerConnection(connectorModel);
        this.assertApiKeyConnection(connectorModel);
        this.assertOAuthClientCredentialsConnection(connectorModel);
        this.assertOAuthAuthorizationCodeConnection(connectorModel);
    }

    private void assertBasicConnection(MuleConnectorModel connectorModel) {
        MuleConnectionProviderModel connectionProviderModel = (MuleConnectionProviderModel)connectorModel.getConnections().get(0);
        MatcherAssert.assertThat((Object)connectionProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"pulseConnector::Connector::connector.connections.basicAuth"));
        Holder httpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(arg_0 -> ((Holder)httpAuthenticationTypeHolder).setValue(arg_0));
        HttpAuthenticationType httpAuthenticationType = (HttpAuthenticationType)httpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)httpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.basic));
        MatcherAssert.assertThat((Object)httpAuthenticationType.getSubType().isEmpty(), (Matcher)Matchers.is((Object)true));
        ObjectType inputType = (ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)connectionProviderModel.getInputType().getDataType());
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"baseUri", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"username", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"password", StringType.class, (boolean)true)}));
        Assertions.assertNull((Object)connectionProviderModel.getTestConnection());
        this.assertAnnotations(inputType);
    }

    private void assertAnnotations(ObjectType inputType) {
        TestUtils.assertLabel((ObjectType)inputType, (String)"baseUri", (String)"Base Uri");
        TestUtils.assertLabel((ObjectType)inputType, (String)"username", (String)"Username");
        TestUtils.assertLabel((ObjectType)inputType, (String)"password", (String)"Password");
        TestUtils.assertSemanticTerms((DWType)inputType, (String)"password", List.of("password"));
        TestUtils.assertLabel((DWType)inputType, (String)"Pulse basic connection");
    }

    private void assertBearerConnection(MuleConnectorModel connectorModel) {
        MuleConnectionProviderModel connectionProviderModel = (MuleConnectionProviderModel)connectorModel.getConnections().get(1);
        MatcherAssert.assertThat((Object)connectionProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"pulseConnector::Connector::connector.connections.bearer"));
        Holder httpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(arg_0 -> ((Holder)httpAuthenticationTypeHolder).setValue(arg_0));
        HttpAuthenticationType httpAuthenticationType = (HttpAuthenticationType)httpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)httpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.bearer));
        MatcherAssert.assertThat((Object)httpAuthenticationType.getSubType().isEmpty(), (Matcher)Matchers.is((Object)true));
        DWType inputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)connectionProviderModel.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)inputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"baseUri", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"token", StringType.class, (boolean)true)}));
        Assertions.assertNull((Object)connectionProviderModel.getTestConnection());
    }

    private void assertApiKeyConnection(MuleConnectorModel connectorModel) {
        MuleConnectionProviderModel connectionProviderModel = (MuleConnectionProviderModel)connectorModel.getConnections().get(2);
        MatcherAssert.assertThat((Object)connectionProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"pulseConnector::Connector::connector.connections.apikey"));
        Holder httpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(arg_0 -> ((Holder)httpAuthenticationTypeHolder).setValue(arg_0));
        HttpAuthenticationType httpAuthenticationType = (HttpAuthenticationType)httpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)httpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.apiKey));
        MatcherAssert.assertThat((Object)httpAuthenticationType.getSubType().isEmpty(), (Matcher)Matchers.is((Object)true));
        DWType inputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)connectionProviderModel.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)inputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"baseUri", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"apiKey", StringType.class, (boolean)true)}));
        Assertions.assertNull((Object)connectionProviderModel.getTestConnection());
    }

    private void assertOAuthClientCredentialsConnection(MuleConnectorModel connectorModel) {
        MuleConnectionProviderModel connectionProviderModel = (MuleConnectionProviderModel)connectorModel.getConnections().get(3);
        MatcherAssert.assertThat((Object)connectionProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"pulseConnector::Connector::connector.connections.oauthClientCredentials"));
        Holder httpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(arg_0 -> ((Holder)httpAuthenticationTypeHolder).setValue(arg_0));
        HttpAuthenticationType httpAuthenticationType = (HttpAuthenticationType)httpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)httpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.oauth2));
        MatcherAssert.assertThat((Object)httpAuthenticationType.getSubType().isEmpty(), (Matcher)Matchers.is((Object)false));
        DWType inputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)connectionProviderModel.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)inputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"accessToken", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"baseUri", StringType.class, (boolean)true)}));
        Assertions.assertNull((Object)connectionProviderModel.getTestConnection());
    }

    private void assertOAuthAuthorizationCodeConnection(MuleConnectorModel connectorModel) {
        MuleConnectionProviderModel connectionProviderModel = (MuleConnectionProviderModel)connectorModel.getConnections().get(4);
        MatcherAssert.assertThat((Object)connectionProviderModel.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)connectionProviderModel.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"pulseConnector::Connector::connector.connections.oauthAuthorizationCode"));
        Holder httpAuthenticationTypeHolder = new Holder();
        connectionProviderModel.getAuthenticationType().accept(arg_0 -> ((Holder)httpAuthenticationTypeHolder).setValue(arg_0));
        HttpAuthenticationType httpAuthenticationType = (HttpAuthenticationType)httpAuthenticationTypeHolder.getValue();
        MatcherAssert.assertThat((Object)httpAuthenticationType.getType(), (Matcher)Matchers.equalTo((Object)HttpAuthenticationType.Type.oauth2));
        MatcherAssert.assertThat((Object)httpAuthenticationType.getSubType().isEmpty(), (Matcher)Matchers.is((Object)false));
        DWType inputType = WeaveTypeSimplifier.simplifyWeaveType((DWType)connectionProviderModel.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat(List.of(((ObjectType)inputType).getProperties()), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"accessToken", StringType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"baseUri", StringType.class, (boolean)true)}));
        Assertions.assertNull((Object)connectionProviderModel.getTestConnection());
    }

    private void assertTestConnection(TestConnectionModel testConnection) {
        MatcherAssert.assertThat((Object)testConnection, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)testConnection.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)testConnection.getModelReference().get()), (Matcher)Matchers.equalTo((Object)"pulseConnector::Connector::connector.testConnection"));
    }

    private void assertRecordObjectType(ObjectType recordType) {
        MatcherAssert.assertThat(List.of(recordType.getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike((String)"recordId", UnionType.class, (boolean)true), ObjectFieldMatcher.fieldLike((String)"friendlyName", StringType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"status", StringType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"type", StringType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"recordIntegerId", NumberType.class, (boolean)false), ObjectFieldMatcher.fieldLike((String)"recordDate", StringType.class, (boolean)false)}));
    }
}

