%dw 2.8

import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Annotations
import * from com::mulesoft::connectivity::transport::Http
import alwaysMapsTo, fromMapping, mapsTo, withTransformer from com::mulesoft::connectivity::codegen::Transformation
import serializeBodyParams, serializeCookies, serializeHeaders, serializeUriParams, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization
import * from com::mulesoft::connectivity::decorator::ValueProvider
import * from com::mulesoft::connectivity::decorator::Executor
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::decorator::PaginationStrategies
import * from com::mulesoft::connectivity::decorator::Trigger
import * from com::mulesoft::connectivity::decorator::ValueProvider
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::Types

// ----------------
// ---- Types -----
// ----------------

type RecordType = {
  recordId: String | Number,
  friendlyName?: String, //{"description": "A human readable description of this record, up to 64 characters long. By default the FriendlyName is your email address."}
  status?: String, //{"description": "The status of this record. Usually `active`, but can be `suspended` or `closed`."}
  "type"?: String, //{"description": "The type of this record. Either `Trial` or `Full` if it's been upgraded"}
  recordIntegerId?: Int32, // Testing "format" number annotation
  recordDate?: LWDate // Testing "format" date annotation
}

type PaginationItem = {
  id: String,
  name: String,
  email: String
  }

type OptionType = "OPTION1" | "OPTION2"

type GetRecordByIdVPPaginatedInputType = {
    page: Number,
    limit: Number,
    recordIdPaginated:  @ValuesFrom(value = { name: "paginatedValueProvider", arguments: {page:  "page", limit: "limit"}}) String,
    staticId?: @ValuesFrom(value = { name: "staticValueProvider"}) "OPTION1" | "OPTION2"
}

type Error404 = Error<"404", "NOT_FOUND">

var error404: Error404 = {
  kind: "404",
  categories: ["NOT_FOUND"]
}

type Error401 = Error<"status-unauthorized", "UNAUTHORIZED">

var error401: Error401 = {
  kind: "status-unauthorized",
  categories: ["UNAUTHORIZED"]
}

type Error400 = Error<"400", "BAD_REQUEST">

var error400: Error400 = {
  kind: "400",
  categories: ["BAD_REQUEST"]
}

type ErrorUnexpected = Error<"status-unexpected", "UNEXPECTED">

var errorUnexpected : ErrorUnexpected = {
  kind: "status-unexpected",
  categories: ["UNEXPECTED"]
}

type ap_get_records_request = {
  customHeaders?: GetRecordsType.request.headers.customHeaders,
  customQueryParams?: GetRecordsType.request.query.customQueryParams
}

type ap_get_record_by_id_request = {
  recordId: @Label(value = "Record ID") GetRecordByIdType.request.uri.recordId,
  recordName?: @Label(value = "Record Name") @DefaultValue(value = "DefaultRecordName") GetRecordByIdType.request.uri.recordName,
  header1?: @Label(value = "Header 1") GetRecordByIdType.request.headers.header1,
  query1: @Label(value = "Query 1") GetRecordByIdType.request.query.queryParam1,
  query2?: @Label(value = "Query 2") GetRecordByIdType.request.query.queryParam2,
  customHeaders?: @Label(value = "Custom Headers") GetRecordByIdType.request.headers.customHeaders,
  customQueryParams?: @Label(value = "Custom Query Params") GetRecordByIdType.request.query.customQueryParams
}

type ap_create_record_request = {
  record: CreateRecordType.request.body,
  customHeaders?: CreateRecordType.request.headers.customHeaders,
  customQueryParams?: CreateRecordType.request.query.customQueryParams
}

type ap_get_record_by_id_static_request = {
  recordId: "OPTION1" | "OPTION3"
}

type ap_get_record_by_id_vp_request = {
  recordId: @ValuesFrom(value = { name: "recordValueProvider"}) String
}

type ap_get_record_by_id_vp_with_param_request = @With(value = { province: "province" }) {
  province: String,
  recordIdWithContextRef:  @ValuesFrom(value = { name: "recordValueProviderParam", arguments: {state: "#province"}}) String,//contextVariable
  recordId:  @ValuesFrom(value = { name: "recordValueProviderParam", arguments: {state:  "/country/province"}}) String,//absoultePath
  recordIdWithRelativePath:  @ValuesFrom(value = { name: "recordValueProviderParam", arguments: {state:  "province"}}) String,//relativePath
  country: {
    province: String
  }
}

type GetRecordByIdType = {
  "200": HttpResponse<RecordType>,
  errorResponse: ResultFailure<HttpResponse<Any>, Error400 | Error404 | Error401 | ErrorUnexpected>,
  request: HttpRequestType<{| uri: {| recordId: String, recordName?: String |}, query: {| queryParam1: String, queryParam2?: String, customQueryParams?: { (String): String } |}, headers: {| header1?: String, customHeaders?: { (String): String } |}, cookie: Object |}>,
  response: GetRecordByIdType."200"
}

type CreateRecordType = {
  "200": HttpResponse<RecordType>,
  errorResponse: ResultFailure<HttpResponse<Any>, Error400 | Error404 | Error401 | ErrorUnexpected>,
  request: HttpRequestType<{| uri: Object, query: {| customQueryParams?: { (String): String } |}, headers: {| customHeaders?: { (String): String } |}, body: RecordType, cookie: Object |}>,
  response: CreateRecordType."200"
}

type GetRecordsType = {
  "200": HttpResponse<Array<RecordType>>,
  errorResponse: ResultFailure<HttpResponse<Any>, Error400 | Error404 | Error401 | ErrorUnexpected>,
  request: HttpRequestType<{| uri: Object, query: {| customQueryParams?: { (String): String } |}, headers: {| customHeaders?: { (String): String } |}, cookie: Object |}>,
  response: GetRecordsType."200"
}

type GetRecordByIdTypeStatic = {
  "200": HttpResponse<RecordType>,
  errorResponse: ResultFailure<HttpResponse<Any>, Error400 | Error404 | Error401 | ErrorUnexpected>,
  request: HttpRequestType<{| uri: {| recordId: String |}, query: Object, headers: Object, cookie: Object |}>,
  response: GetRecordByIdTypeStatic."200"
}

type GetRecordByIdVPType = {
  "200": HttpResponse<RecordType>,
  errorResponse: ResultFailure<HttpResponse<Any>, Error400 | Error404 | Error401 | ErrorUnexpected>,
  request: HttpRequestType<{| uri: {| recordId: String |}, query: Object, headers: Object, cookie: Object |}>,
  response: GetRecordByIdVPType."200"
}

type GetRecordByIdVPWithParamType = {
  "200": HttpResponse<RecordType>,
  errorResponse: ResultFailure<HttpResponse<Any>, Error400 | Error404 | Error401 | ErrorUnexpected>,
  request: HttpRequestType<{| uri: {| recordId: String, province: String, recordIdWithContextRef: String, recordIdWithRelativePath: String|}, query: Object, headers: Object, body: {province: String}, cookie: Object |}>,
  response: GetRecordByIdVPType."200"
}

// ----------------
// -- Mappings --
// ----------------

var ap_create_record_mapping = [
  {} alwaysMapsTo "uri",
  {} alwaysMapsTo "headers",
  {} alwaysMapsTo "query",
  "customHeaders" mapsTo  "headers.customHeaders",
  "customQueryParams" mapsTo  "query.customQueryParams",
  {} alwaysMapsTo "cookie",
  "record" mapsTo  "body"
]

var ap_get_record_by_id_mapping = [
  "recordId" mapsTo "uri.recordId",
  "recordName" mapsTo "uri.recordName",
  {} alwaysMapsTo "headers",
  {} alwaysMapsTo "query",
  "query1" mapsTo "query.queryParam1",
  "query2" mapsTo "query.queryParam2",
  "header1" mapsTo "headers.header1",
  "customHeaders" mapsTo  "headers.customHeaders",
  "customQueryParams" mapsTo  "query.customQueryParams",
  {} alwaysMapsTo "cookie"
]

var ap_get_records_mapping = [
  {} alwaysMapsTo "uri",
  {} alwaysMapsTo "headers",
  {} alwaysMapsTo "query",
  "customHeaders" mapsTo  "headers.customHeaders",
  "customQueryParams" mapsTo  "query.customQueryParams",
  {} alwaysMapsTo "cookie"
]

var ap_get_record_by_id_static_mapping = [
  "recordId" mapsTo "uri.recordId",
  {} alwaysMapsTo "headers",
  {} alwaysMapsTo "query",
  {} alwaysMapsTo "cookie"
]

var ap_get_record_by_id_vp_mapping = [
  "recordId" mapsTo "uri.recordId",
  {} alwaysMapsTo "headers",
  {} alwaysMapsTo "query",
  {} alwaysMapsTo "cookie"
]

var ap_get_record_by_id_vp_with_param_mapping = [
  "recordId" mapsTo "uri.recordId",
  "recordIdWithContextRef" mapsTo  "uri.recordIdWithContextRef",
  "recordIdWithRelativePath" mapsTo  "uri.recordIdWithRelativePath",
  {} alwaysMapsTo "headers",
  {} alwaysMapsTo "query",
  {} alwaysMapsTo "cookie",
  "country" mapsTo  "body"
]

// -------------------
// -- Helper Method --
// -------------------
fun extractSuccessResponse<T>(response: HttpResponse<T>): SuccessResponseType<T> =
  {
    rawBody: (response.body.^raw default "") as Binary,
    contentType: response.contentType default "",
    attributes: {
      statusCode: response.status,
      statusText: response.statusText default ""
    }
  }

  fun extractFailureResponse(operation) =
    operation update {
      case executor at .executor -> mapFailureResult(operation.executor, (failure) ->
        (failure update {
          case response at .error.value -> {
            rawBody: (response.body.^raw default null) as Binary,
            contentType: (response.contentType default ""),
            attributes: {
              errorKind: failure.error.kind,
              errorCategory: failure.error.categories
            }
          }
        }) as ResultFailure<FailureResponseType, Error400 | Error404 | Error401 | ErrorUnexpected>
      )
    }

type FailureResponseType = {
  rawBody: Binary,
  contentType: String,
  attributes: {
    errorKind: String,
    errorCategory: Array<String>
  }
}

type SuccessResponseType<T> = {
  body?: T,
  rawBody: Binary,
  contentType: String,
  attributes: {
    statusCode: Number,
    statusText?: String
  }
}

// ----------------
// -- Connection --
// ----------------

type BasicConnection = @Label(value = "Pulse basic connection") @Description(value= "Pulse basic description") {
  baseUri: @Label(value = "Base Uri") @Description( value = "The base URI Description") String,
  username: @Label(value = "Username") String,
  password: @Label(value = "Password") @SemanticTerms(value = ["password"]) String
}

type BearerConnection = @Label(value = "bearer") @Description(value = "Pulse bearer connection") {
  baseUri: @Label(value = "The base URI that will be used for all HTTP requests") String,
  token: @Label(value = "Token used to authenticate the request") String
}

@ConnectionElement()
var basicConnectionProvider: BasicHttpConnectionProvider<BasicConnection> =
  defineBasicHttpConnectionProvider<BasicConnection>(
    (parameter: BasicConnection) -> {
      username: parameter.username,
      password: parameter.password
    },
    (parameter: BasicConnection) -> { baseUri: parameter.baseUri }
  )

@ConnectionElement()
var bearerConnectionProvider: BearerHttpConnectionProvider<BearerConnection> = defineBearerHttpConnectionProvider<BearerAuthSchema & { baseUri: String }>(
    (connectionInfo) -> {token: connectionInfo.token},
    (parameter) -> {baseUri: parameter.baseUri}
)

@ConnectionElement()
var apiKeyHeaderConnectionProvider =
  defineApiKeyHttpConnectionProvider<{ baseUri: String, apiKey: String }>(
    (parameter) -> { apiKey: parameter.apiKey },
    (parameter) -> { baseUri: parameter.baseUri },
    { in: 'header', name: "X-API-KEY" }
  )

@ConnectionElement()
var oauth2CcConnectionProvider = defineOAuth2Connection<OAuth2AuthSchema & {
  baseUri: String }>((schema) -> {
  accessToken: schema.accessToken
}, (schema) -> {
  baseUri: schema.baseUri
}, {
  grantType: "clientCredentials",
  tokenUrl: "https://pulse.com/token",
  refreshUrl: "https://pulse.com/token",
  scopes: ["read", "write"]
}, {
                   extensions:
                      (parameter) -> [
                                  {in: "header", name:"myheaderparam", value: "headerValue"},
                                  {in: "query", name:"myqueryparam", value: "queryValue"},
                                  {in: "path", name:"myuriparam", value: "uriValue"},
                                  {in: "body", name:"mybodyparam", value: "bodyValue"},
                               ],
                   responseInterceptors: [
                               (httpResponse) -> if (httpResponse.status == 200 and httpResponse.statusText == "Unauthorized")
                                                    httpResponse update {
                                                       case .status! -> 401
                                                    }
                                                 else
                                                 httpResponse
                            ]
                })

@ConnectionElement()
var oauth2AcConnectionProvider = defineOAuth2Connection<OAuth2AuthSchema & {
  baseUri: String }>((schema) -> {
  accessToken: schema.accessToken
}, (schema) -> {
  baseUri: schema.baseUri
}, {
  grantType: "authorizationCode",
  authorizationUrl: "https://pulse.com/authorize",
  tokenUrl: "https://pulse.com/token",
  refreshUrl: "https://pulse.com/token",
  scopes: ["read", "write"]
}, {
                     extensions:
                        (parameter) -> [
                                    {in: "header", name:"myheaderparam", value: "headerValue"},
                                    {in: "query", name:"myqueryparam", value: "queryValue"},
                                    {in: "path", name:"myuriparam", value: "uriValue"},
                                    {in: "body", name:"mybodyparam", value: "bodyValue"},
                                 ],
                     responseInterceptors: [
                                 (httpResponse) -> if (httpResponse.status == 200 and httpResponse.statusText == "Unauthorized")
                                                      httpResponse update {
                                                         case .status! -> 401
                                                      }
                                                   else
                                                   httpResponse
                              ]
                  })

// ---------------------
// -- Operations --
// ---------------------

var get_record_by_id = {
    name: "getRecordById",
    displayName: "Get Record by Id",
    executor: (parameter: GetRecordByIdType.request, connection: HttpConnection): Result<GetRecordByIdType.response, GetRecordByIdType.errorResponse> -> do {
        var uri = serializeUriParams(parameter.uri, {})
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        var response = connection({
          method: "GET",
          path: "records/$(uri.recordId)/$(uri.recordName)",
          queryParams: query,
          headers: headers,
          cookie: cookie
        })
        ---
        response match {
          case response200 if response200.status == 200 and response200 is GetRecordByIdType."200" -> success(response200 as GetRecordByIdType."200")
          case response404 if response.status == 404 -> failure(response404, error404)
          case response400 if response.status == 400 -> failure(response400, error400)
          case response401 if response.status == 401 -> failure(response, error401)
          else responseDefault -> failure(responseDefault, errorUnexpected)
        }
      }
}

var create_record = {
    name: "createRecord",
    displayName: "Create Record",
    executor: (parameter: CreateRecordType.request, connection: HttpConnection): Result<CreateRecordType.response, CreateRecordType.errorResponse> -> do {
        var uri = serializeUriParams(parameter.uri, {})
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        var body = serializeBodyParams(parameter.body default {}, {})
        var response = connection({
          method: "POST",
          path: "records",
          queryParams: query,
          headers: headers,
          cookie: cookie,
          body: body
        })
        ---
        response match {
          case response200 if response200.status == 200 and response200 is CreateRecordType."200" -> success(response200 as CreateRecordType."200")
          case response404 if response.status == 404 -> failure(response404, error404)
          case response400 if response.status == 400 -> failure(response400, error400)
          case response401 if response.status == 401 -> failure(response, error401)
          else responseDefault -> failure(responseDefault, errorUnexpected)
        }
      }
}

var get_records = {
    name: "getRecords",
    displayName: "Get Records",
    executor: (parameter: GetRecordsType.request, connection: HttpConnection): Result<GetRecordsType.response, GetRecordsType.errorResponse> -> do {
        var uri = serializeUriParams(parameter.uri, {})
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        var response = connection({
          method: "GET",
          path: "records",
          queryParams: query,
          headers: headers,
          cookie: cookie
        })
        ---
        response match {
          case response200 if response200.status == 200 and response200 is GetRecordsType."200" -> success(response200 as GetRecordsType."200")
          case response404 if response.status == 404 -> failure(response404, error404)
          case response400 if response.status == 400 -> failure(response400, error400)
          case response401 if response.status == 401 -> failure(response, error401)
          else responseDefault -> failure(responseDefault, errorUnexpected)
        }
      }
}

var get_record_by_id_static = {
    name: "getRecordByIdStatic",
    displayName: "Get Record by Id Static",
    executor: (parameter: GetRecordByIdTypeStatic.request, connection: HttpConnection): Result<GetRecordByIdTypeStatic.response, GetRecordByIdTypeStatic.errorResponse> -> do {
        var uri = serializeUriParams(parameter.uri, {})
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        var response = connection({
          method: "GET",
          path: "records/$(uri.recordId)",
          queryParams: query,
          headers: headers,
          cookie: cookie
        })
        ---
        response match {
          case response200 if response200.status == 200 and response200 is GetRecordByIdTypeStatic."200" -> success(response200 as GetRecordByIdTypeStatic."200")
          case response404 if response.status == 404 -> failure(response404, error404)
          case response400 if response.status == 400 -> failure(response400, error400)
          case response401 if response.status == 401 -> failure(response, error401)
          else responseDefault -> failure(responseDefault, errorUnexpected)
        }
      }
}

var get_record_by_id_vp = {
    name: "getRecordByIdVP",
    displayName: "Get Record by Id VP",
    executor: (parameter: GetRecordByIdVPType.request, connection: HttpConnection): Result<GetRecordByIdVPType.response, GetRecordByIdVPType.errorResponse> -> do {
        var uri = serializeUriParams(parameter.uri, {})
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        var response = connection({
          method: "GET",
          path: "records/$(uri.recordId)",
          queryParams: query,
          headers: headers,
          cookie: cookie
        })
        ---
        response match {
          case response200 if response200.status == 200 and response200 is GetRecordByIdVPType."200" -> success(response200 as GetRecordByIdVPType."200")
          case response404 if response.status == 404 -> failure(response404, error404)
          case response400 if response.status == 400 -> failure(response400, error400)
          case response401 if response.status == 401 -> failure(response, error401)
          else responseDefault -> failure(responseDefault, errorUnexpected)
        }
      }
}

var get_record_by_id_vp_with_param = {
    name: "getRecordByIdVPWithParam",
    displayName: "Get Record by Id VP With Param",
    executor: (parameter: GetRecordByIdVPWithParamType.request, connection: HttpConnection): Result<GetRecordByIdVPWithParamType.response, GetRecordByIdVPWithParamType.errorResponse> -> do {
        var uri = serializeUriParams(parameter.uri, {})
        var query = parameter.query default {} withSerializationConfig {}
        var headers = serializeHeaders(parameter.headers default {}, {})
        var cookie = serializeCookies(parameter.cookie default {}, {})
        var response = connection({
          method: "GET",
          path: "records/$(uri.recordId)",
          queryParams: query,
          headers: headers,
          cookie: cookie
        })
        ---
        response match {
          case response200 if response200.status == 200 and response200 is GetRecordByIdVPWithParamType."200" -> success(response200 as GetRecordByIdVPWithParamType."200")
          case response404 if response.status == 404 -> failure(response404, error404)
          case response400 if response.status == 400 -> failure(response400, error400)
          case response401 if response.status == 401 -> failure(response, error401)
          else responseDefault -> failure(responseDefault, errorUnexpected)
        }
      }
}

@OperationElement()
var getRecordById: Operation<ap_get_record_by_id_request, SuccessResponseType<RecordType>, ResultFailure<FailureResponseType, Error400 | Error404 | Error401 | ErrorUnexpected>, HttpConnection> = do {
  var base = get_record_by_id withTransformer {
    in: fromMapping<ap_get_record_by_id_request, GetRecordByIdType.request>(ap_get_record_by_id_mapping),
    out: (response) -> extractSuccessResponse(response) as SuccessResponseType<RecordType>
  }
  ---
  extractFailureResponse(base)
}

@OperationElement()
var createRecord: Operation<ap_create_record_request, SuccessResponseType<RecordType>, ResultFailure<FailureResponseType, Error400 | Error404 | Error401 | ErrorUnexpected>, HttpConnection> = do {
  var base = create_record withTransformer {
    in: fromMapping<ap_create_record_request, CreateRecordType.request>(ap_create_record_mapping),
    out: (response) -> extractSuccessResponse(response) as SuccessResponseType<RecordType>
  }
  ---
  extractFailureResponse(base)
}

@OperationElement()
var getRecords: Operation<ap_get_records_request, SuccessResponseType<Array<RecordType>>, ResultFailure<FailureResponseType, Error400 | Error404 | Error401 | ErrorUnexpected>, HttpConnection> = do {
  var base = get_records withTransformer {
    in: fromMapping<ap_get_records_request, GetRecordsType.request>(ap_get_records_mapping),
    out: (response) -> extractSuccessResponse(response) as SuccessResponseType<Array<RecordType>>
  }
  ---
  extractFailureResponse(base)
}

@OperationElement()
var getRecordByIdStatic: Operation<ap_get_record_by_id_static_request, SuccessResponseType<RecordType>, ResultFailure<FailureResponseType, Error400 | Error404 | Error401 | ErrorUnexpected>, HttpConnection> = do {
  var base = get_record_by_id_static withTransformer {
    in: fromMapping<ap_get_record_by_id_static_request, GetRecordByIdTypeStatic.request>(ap_get_record_by_id_static_mapping),
    out: (response) -> extractSuccessResponse(response) as SuccessResponseType<RecordType>
  }
  ---
  extractFailureResponse(base)
}

@OperationElement()
var getRecordByIdVP: Operation<ap_get_record_by_id_vp_request, SuccessResponseType<RecordType>, ResultFailure<FailureResponseType, Error400 | Error404 | Error401 | ErrorUnexpected>, HttpConnection> = do {
  var base = get_record_by_id_vp withTransformer {
    in: fromMapping<ap_get_record_by_id_vp_request, GetRecordByIdVPType.request>(ap_get_record_by_id_vp_mapping),
    out: (response) -> extractSuccessResponse(response) as SuccessResponseType<RecordType>
  }
  ---
  extractFailureResponse(base)
}

@OperationElement()
var getRecordByIdVPWithParam: Operation<ap_get_record_by_id_vp_with_param_request, SuccessResponseType<RecordType>, ResultFailure<FailureResponseType, Error400 | Error404 | Error401 | ErrorUnexpected>, HttpConnection> = do {
  var base = get_record_by_id_vp_with_param withTransformer {
    in: fromMapping<ap_get_record_by_id_vp_with_param_request, GetRecordByIdVPWithParamType.request>(ap_get_record_by_id_vp_with_param_mapping),
    out: (response) -> extractSuccessResponse(response) as SuccessResponseType<RecordType>
  }
  ---
  extractFailureResponse(base)
}

var getOffset : Operation<{from: String, limit: String}, HttpResponse<{items: Array<PaginationItem>}>, ResultFailure<HttpResponse, Error400 | Error404 | ErrorUnexpected>, HttpConnection> = {
    name: "getOffset",
    displayName: "Get Offset",
    executor: (parameter, connection) -> do {
        var response = connection({method: 'GET',
        path: "offset",
        queryParams: {from: parameter.from, limit: parameter.limit}
        })
        ---
        if (response.status == 200)
          success(response as HttpResponse<{items: Array<PaginationItem>}>)
              else if (response.status == 404)
                failure(response, error404)
              else if (response.status == 400)
                failure(response, error400)
              else
                failure(response, errorUnexpected)
    }
}

@OperationElement()
var getOffsetPaginated = offsetPaginated(
  getOffset,
  (page) -> page.body.items default [],
  (param) -> param.from as Number default 0,
  (param, offset) -> (param update { case from at .from! -> offset as String})
  )

@OperationElement()
var getPageNumber : Operation<{page: String, limit: String}, HttpResponse<{items: Array<PaginationItem>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getPageNumber",
    displayName: "Get Page Number",
    executor: (parameter, connection) -> do {
        var response = connection({method: 'GET',
         path: "pageNumber",
         queryParams: {page: parameter.page, limit: parameter.limit}
         }
         )
        ---
        if (response.status == 200)
         success(response as HttpResponse<{items: Array<PaginationItem>}>)
        else
         failure(response)
    }
}

@OperationElement()
var getPageNumberPaginated = pageNumberPaginated(
  getPageNumber,
  (page) -> page.body.items default [],
  (param) -> param.page as Number default 0,
  (param, pageNumber) -> (param update { case page at .page! -> pageNumber as String })
  )

@OperationElement()
var getMarker : Operation<{markerToken?: String, limit: String}, HttpResponse<{items: Array<PaginationItem>, markerToken?: String}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getMarker",
    displayName: "Get Marker",
    executor: (parameter, connection) -> do {
        var markerParams = if(!isEmpty(parameter.markerToken)) ("?markerToken=" ++ parameter.markerToken! ++ "&limit=" ++ parameter.limit) else ("?limit=" ++ parameter.limit)
        var response = connection({method: 'GET', path: "marker" ++ markerParams})
        ---
         if (response.status == 200)
         success(response as HttpResponse<{items: Array<PaginationItem>, markerToken?: String}>)
         else
          failure(response)
    }
}

@OperationElement()
var getMarkerPaginated = markerPaginated(
  getMarker,
  (page) -> page.body.items default [],
  (page) -> page.body.markerToken default "",
  (param, marker) -> (param update { case markerToken at .markerToken! -> marker })
  )

@OperationElement()
var getHypermedia : Operation<{pageMarker?: String, limit?: String}, HttpResponse<{items: Array<PaginationItem>, nextUrl?: String}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getHypermedia",
    displayName: "Get Hypermedia",
    executor: (parameter, connection) -> do {
       var response = connection({method: 'GET', path: "hypermedia?pageMarker=" ++ (parameter.pageMarker default "") ++ "&limit=" ++ (parameter.limit default "")})
        ---
        if (response.status == 200)
        success(response as HttpResponse<{items: Array<PaginationItem>, nextUrl?: String}>)
        else
          failure(response)
    }
}

@OperationElement()
var getHypermediaPaginated =
  hypermediaPaginated(
   getHypermedia,
   (page) -> page.body.items default [],
   (page) -> page.body.nextUrl default "",
   (param, nextUrl) -> parseQueryParameters(nextUrl)
  )

@OperationElement()
var isAlive: Operation<HttpRequestType<{}>, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> do {
        var response = connection({
            method: "GET",
            path: "testConnection"
        })
        ---
        if (response.status == 200)
          success({
            status: response.status,
            statusText: response.statusText default "",
            headers: response.headers default {},
            body: response.body default null,
            cookies: response.cookies default {}
          })
        else
          failure(response)
    }
}

fun paginatedRecordIdsValueProviderExecutor(): Executor<{ page?: Number, limit?: Number }, Page<PaginationItem, {| page: Number, limit: Number |}>, ResultFailure<{}, Error>, HttpConnection> =
  (parameter, connection) -> do {
        var page = parameter.page default 1
        var limit = parameter.limit default 2

        // Use getPageNumberPaginated operation
        var pageResult = getPageNumberPaginated.executor({page: page as String, limit: limit as String}, connection)

        var records =
        if (pageResult.success)
            pageResult.value.items as Array<PaginationItem>
        else []
        var hasNext = sizeOf(records) == limit
        var result = {
        items: records
        } ++ (if (hasNext) { nextPage: { args: { page: page + 1, limit: limit } } } else {})
        ---
        success(result)
    }

var paginatedValueProvider = definePaginatedValueProvider(
      paginatedRecordIdsValueProviderExecutor() mapInput (param:  {page: Number, limit : Number}) ->  {page: param.page, limit: param.limit},
   (page) -> page.items map { value: $.id, displayValue: { label: $.email } }
 )

var recordValueProvider = defineValueProvider(
  get_records.executor mapInput (param) ->  {uri: {}, query: {}, headers: {}, cookie: {}},
  	(response) ->
  	if (response.body != null)
      	 do {
             response.body map ((item, index) -> {value: item.recordId,
             displayValue: { label:(item.friendlyName default "Unknown Record") as String, properties: {helpText: item.recordId as String} }})  default []
  	}
  	else
  	    []
  	   )

 var recordValueProviderParam = defineValueProvider(
  get_record_by_id.executor mapInput (param: {state: String}) -> {uri: {recordId: param.state, recordName: ""}, query: {queryParam1: ""}, headers: {}, cookie: {}},
  	(response) ->
  	    if (response.body != null)
  	    do {
                     if (response.body.recordId != null)
                         [{value: response.body.recordId, displayValue: { label: response.body.friendlyName default response.body.recordId.toString() }}]
                     else
                         []
                 }
  	    else
  	        []
 )

var staticValueProvider = defineValueProvider(
    (parameter: {}, connection) -> success(["OPTION1", "OPTION2"]),
    (response: Array<OptionType>) -> response map {value: $, displayValue: {label: $}}
)

@OperationElement()
var getRecordByIdVPPaginated : Operation<HttpRequestType<GetRecordByIdVPPaginatedInputType>, HttpResponse<{items: Array<PaginationItem>}>,ResultFailure<HttpResponse, Error>, HttpConnection> =
{
   name: "getRecordByIdVPPaginated",
   displayName: "Get Record by Id VP With Param",
     executor: (parameter, connection) -> do {
        var response = connection({method: 'GET',
         path: "/paginatedOperation",
         })
        ---
        if (response.status == 200)
         success(response as HttpResponse<{items: Array<PaginationItem>}>)
        else
         failure(response)
    }
}

// ---------------------
// -- Test Connection --
// ---------------------
@TestConnectionElement()
var testConnection: HttpTestConnection = {
	validate: defineTestConnection(
              	isAlive,
                (response) -> {
                  isValid: response.value.status == 200,
                  message: if (response.value.status == 200) "Connection test succeeded" else "Connection test failed",
                  (error: response.description default "") if (!isEmpty(response.description))
                }
    )
}

// ---------------------
// --    Trigger      --
// ---------------------

type DemoTriggerItem = {
  pollID: Number,
  pageID: Number,
  pageLocalID: Number,
  pollLocalID: Number,
  globalID: Number
}
type DemoTriggerPageRequest = {
  pollID: Number,
  pageID: Number,
  itemsPerPoll: Number,
  itemsPerPage: Number,
  totalItems: Number
}
type DemoTriggerRequest = {
  itemsPerPage: Number,
  itemsPerPoll: Number,
  totalItems: Number
}
type DemoTriggerPageResponse = Array<DemoTriggerItem>

var getDemoTriggerPage: HttpOperation<DemoTriggerPageRequest, DemoTriggerPageResponse, Nothing, HttpConnection> = {
    name: "getTriggerPage",
    displayName: "INTERNAL: Demo trigger operation",
    executor: (params, connection) -> do {
        var pollStart = params.pollID * params.itemsPerPoll
        var pageStart = pollStart + params.pageID * params.itemsPerPage
        var pageEnd = min([pageStart + params.itemsPerPage, params.totalItems])
        var globalIDs = (pageStart to pageEnd - 1) as Array<Number>
        var items = globalIDs map ({
            pollID: params.pollID,
            pageID: params.pageID,
            pollLocalID: $ - pollStart,
            pageLocalID: $ - pageStart,
            globalID: $
        })
        ---
        success({
            contentType: "application/json",
            status: 200,
            headers: {},
            cookies: {},
            body: items
        } as HttpResponse<DemoTriggerPageResponse>)
    }
}

var getDemoTriggerPagePaginated: PaginatedOperation<DemoTriggerPageRequest, DemoTriggerPageRequest, Page<DemoTriggerItem, DemoTriggerPageRequest>,  ResultFailure<HttpResponse<Nothing>, Error>, HttpConnection> =
    getDemoTriggerPage paginated (params, page) -> {
        items: page.body!,
        (nextPage: {
            args: params update {
              case .pageID -> $ + 1
            }
        }) if (params.pageID < ceil(params.itemsPerPoll / params.itemsPerPage) - 1)
    }

var demoTriggerStrategy: TriggerStrategy<HttpResponse<DemoTriggerPageResponse>, DemoTriggerItem, DemoTriggerItem, Number> = {
    items: (result) -> result.body!,
    item: (item) -> item,
    watermark: (result, item) -> item.globalID,
    identity: (item) -> write(item.globalID, 'application/json') as String,
    watermarkCompareTo: DefaultWatermarkComparison
}


var demoTriggerPaginatedStrategy: TriggerStrategy<Page<DemoTriggerItem, DemoTriggerPageRequest>, DemoTriggerItem, DemoTriggerItem, Number> = {
    items: (result) -> result.items,
    item: (item) -> item,
    watermark: (result, item) -> item.globalID,
    identity: (item) -> write(item.globalID, 'application/json') as String,
    watermarkCompareTo: DefaultWatermarkComparison
}

@TriggerElement()
var paginatedTrigger: Trigger<DemoTriggerRequest, DemoTriggerPageRequest, Page<DemoTriggerItem, DemoTriggerPageRequest>, DemoTriggerPageRequest, ResultFailure, HttpConnection, DemoTriggerItem, DemoTriggerItem, Number> = {
    name: "paginatedTrigger",
    displayName: "Trigger that has multiple items per page and multiple pages per poll",
    metadata: {
        order: "ASC",
        paginated: true
    },
    strategy: demoTriggerPaginatedStrategy,
    operation: getDemoTriggerPagePaginated,
    inputMapper: (triggerInput: DemoTriggerRequest, watermark) -> {
      pollID: ceil(watermark / triggerInput.itemsPerPoll),
      pageID: 0,
      (triggerInput)
    },
    initialWatermark: (triggerInput: DemoTriggerRequest, connection) -> 0,
}

@TriggerElement()
var nonPaginatedTrigger: Trigger<DemoTriggerRequest, DemoTriggerPageRequest, HttpResponse<DemoTriggerPageResponse>, DemoTriggerPageRequest, ResultFailure, HttpConnection, DemoTriggerItem, DemoTriggerItem, Number> = {
    name: "nonPaginatedTrigger",
    displayName: "Trigger that has multiple items per page and a single page per poll",
    metadata: {
        order: "ASC",
        paginated: false
    },
    strategy: demoTriggerStrategy,
    operation: getDemoTriggerPage,
    inputMapper: (triggerInput: DemoTriggerRequest, watermark) -> {
      pollID: ceil(watermark / triggerInput.itemsPerPoll),
      pageID: 0,
      (triggerInput)
    },
    initialWatermark: (triggerInput: DemoTriggerRequest, connection) -> 0,
}
