%dw 2.8
import * from com::mulesoft::connectivity::mule::Metadata
import * from pulseConnector::Module

@MuleConnectorElement()
var connector = {
                    name: "PULSE",
                    displayName: "Pulse Connector",
                    version: "1.2.3",
                    description: "Pulse Connector to test the IC Mule Extension",
                    vendor: "Salesforce",
                    category: "community",
                    connections: {
                        basicAuth: basicConnectionProvider,
                        bearer: bearerConnectionProvider,
                        apikey: apiKeyHeaderConnectionProvider,
                        oauthClientCredentials: oauth2CcConnectionProvider,
                        oauthAuthorizationCode: oauth2AcConnectionProvider
                    },
                    testConnection: testConnection,
                    operations: {
                        getRecords: getRecords,
                        getRecordById: getRecordById,
                        createRecord: createRecord,
                        getOffsetPaginated: getOffsetPaginated,
                        getPageNumberPaginated: getPageNumberPaginated,
                        getHypermediaPaginated: getHypermediaPaginated,
                        getMarkerPaginated: getMarkerPaginated,
                        getRecordByIdStatic: getRecordByIdStatic,
                        getRecordByIdVP: getRecordByIdVP,
                        getRecordByIdVPWithParam: getRecordByIdVPWithParam,
                        getRecordByIdVPPaginated: getRecordByIdVPPaginated
                    },
                    triggers: {
                        paginatedTrigger: paginatedTrigger,
                        nonPaginatedTrigger: nonPaginatedTrigger
                    },
                    valueProviders: {
                        recordValueProviderParam: recordValueProviderParam,
                        recordValueProvider: recordValueProvider,
                        paginatedValueProvider: paginatedValueProvider,
                        staticValueProvider : staticValueProvider
                    }
                }
