/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.connectivity.mule.internal.metadata;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.weave.v2.ts.MetadataValue;

import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;
import com.mulesoft.connectivity.mule.persistence.metadata.FormatAnnotation;

public class FormatAnnotationFactory implements TypeAnnotationFactory {

  public static final String ANNOTATION_FORMAT = "The 'format' metadata";
  public static final String FORMAT_ANNOTATION_KEY = "format";

  @Override
  public String getKey() {
    return FORMAT_ANNOTATION_KEY;
  }

  @Override
  public TypeAnnotation create(MetadataValue metadataValue) {
    return new FormatAnnotation(MetadataValueUtils.asString(metadataValue, ANNOTATION_FORMAT));
  }
}
