/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.connectivity.mule.internal.persistence;

import org.mule.metadata.api.model.MetadataType;

import com.mulesoft.connectivity.mule.persistence.serialize.BaseMetadataTypeGsonTypeAdapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;

/**
 * {@link Gson} {@link TypeAdapter}&lt;{@link MetadataType}&gt; that helps to serialize {@link MetadataType} objects, by using
 * both {@link MetadataTypeWriterWithExternalCatalog} to generate a light-weight JSON for better generation, transportation and
 * storage.
 */
public final class MetadataTypeGsonTypeAdapterWithExternalCatalog extends BaseMetadataTypeGsonTypeAdapter {

  public MetadataTypeGsonTypeAdapterWithExternalCatalog(CatalogTypeCollector catalogTypeCollector) {
    super(new MetadataTypeWriterWithExternalCatalog(catalogTypeCollector));
  }
}
