/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.connectivity.mule.internal.persistence;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.serializer.TypeSerializerVisitor;

import com.mulesoft.connectivity.mule.persistence.serialize.AbstractJsonMetadataTypeWriter;

/**
 * {@link org.mule.metadata.persistence.MetadataTypeWriter} implementation that serializes a {@link MetadataType} object into a
 * JSON object by creating a type catalog for all {@link org.mule.metadata.api.model.ObjectType}s found.
 */
public class MetadataTypeWriterWithExternalCatalog extends AbstractJsonMetadataTypeWriter {

  private final CatalogTypeCollector catalogCollector;

  public MetadataTypeWriterWithExternalCatalog(CatalogTypeCollector catalogCollector) {
    this.catalogCollector = catalogCollector;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void write(MetadataType type) {
    ObjectTypeReferenceHandler referenceHandler = new ExternalCatalogObjectTypeReferenceHandler(catalogCollector);
    type.accept(catalogCollector);
    writeModel(type, referenceHandler);
  }

  private void writeModel(MetadataType type, ObjectTypeReferenceHandler referenceHandler) {
    type.accept(new MetadataTypeVisitor() {

      @Override
      protected void defaultVisit(MetadataType metadataType) {
        type.accept(new TypeSerializerVisitor(writer, referenceHandler, typeStack, false));
      }
    });
  }

}
