/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.persistence;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.mule.internal.loader.MuleConnectorLoaderFactory;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectorModel;
import com.mulesoft.connectivity.mule.internal.persistence.MuleModelSerializer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.NoSuchElementException;
import org.jspecify.annotations.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.Category;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

class MuleModelSerializerTest {
    private final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();
    private final LanguageModelLoader<@NonNull MuleConnectorModel, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MuleConnectorModel.Builder> muleLoader = new LanguageModelLoader(this.dataWeaveEngine, (ModelLoader)new MuleConnectorLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::mule::Metadata::MuleConnectorElement"));

    MuleModelSerializerTest() {
    }

    @ValueSource(strings={"pulseConnector"})
    @ParameterizedTest
    void testMuleModelSerializer(String connectorName) throws IOException {
        this.doSerializedModelVerification(connectorName + "::Connector", "/" + connectorName + "/serializedModel.ic");
    }

    @Test
    void testMuleModelSerializerWithException() {
        MuleConnectorModel connectorModel = (MuleConnectorModel)Mockito.mock(MuleConnectorModel.class);
        Mockito.when((Object)connectorModel.getName()).thenReturn((Object)"PULSE");
        Mockito.when((Object)connectorModel.getCategory()).thenReturn((Object)Category.COMMUNITY);
        Exception exception = (Exception)Assertions.assertThrows(NoSuchElementException.class, () -> new MuleModelSerializer().serialize(connectorModel));
        Assertions.assertEquals((Object)"Every connector should have a model reference", (Object)exception.getMessage());
    }

    private void doSerializedModelVerification(String moduleReference, String serializedModelResource) throws IOException {
        JsonElement actual;
        MuleConnectorModel connectorModel = (MuleConnectorModel)this.muleLoader.loadModule(moduleReference);
        MuleModelSerializer muleModelSerializer = new MuleModelSerializer();
        String actualSerializedModel = muleModelSerializer.serialize(connectorModel);
        URL resourceUrl = MuleModelSerializerTest.getResource(serializedModelResource);
        InputStreamReader expectedSerializedModel = MuleModelSerializerTest.getResourceAsReader(resourceUrl);
        JsonElement expected = JsonParser.parseReader((Reader)expectedSerializedModel);
        if (!expected.equals(actual = JsonParser.parseString((String)actualSerializedModel))) {
            try {
                Object actualFile = String.valueOf(Paths.get(resourceUrl.toURI())) + ".actual";
                actualFile = ((String)actualFile).replace("/target/test-classes/", "/src/test/resources/");
                Files.writeString(Paths.get((String)actualFile, new String[0]), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson(actual), new OpenOption[0]);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    private static URL getResource(String fileName) throws FileNotFoundException {
        URL resourceUrl = MuleModelSerializerTest.class.getResource(fileName);
        if (resourceUrl == null) {
            throw new FileNotFoundException("Can't find resource '" + fileName + "'");
        }
        return resourceUrl;
    }

    private static InputStreamReader getResourceAsReader(URL resourceUrl) throws IOException {
        return new InputStreamReader(resourceUrl.openStream(), StandardCharsets.UTF_8);
    }
}

