/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.connectivity.mule.internal.loader;

import com.mulesoft.connectivity.linkweave.api.loader.LanguageLoaderFactory;
import com.mulesoft.connectivity.linkweave.api.loader.impl.OperationLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.loader.impl.TestConnectionLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.loader.impl.TriggerLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.loader.impl.ValueProviderLoaderImpl;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectorModel;

/**
 * Creates ModelLoaderFactory for Mule.
 */
public class MuleConnectorLoaderFactory implements LanguageLoaderFactory<MuleConnectorModel, MuleConnectorModel.Builder> {

  @Override
  public MuleConnectorLoader create() {
    var testConnectionLoader = new TestConnectionLoaderImpl();
    return new MuleConnectorLoader(new MuleConnectionProviderLoader(testConnectionLoader), testConnectionLoader,
                                   new OperationLoaderImpl(), new TriggerLoaderImpl(), new ValueProviderLoaderImpl());

  }
}
