/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.connectivity.mule.internal.loader;

import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectorModel;

import org.jspecify.annotations.NonNull;

/**
 * LanguageModelLoader for loading {@link MuleConnectorModel}.
 */
public class MuleModelLoader extends LanguageModelLoader<@NonNull MuleConnectorModel, MuleConnectorModel.@NonNull Builder> {

  public MuleModelLoader(DataWeaveScriptingEngine dataWeaveEngine) {
    super(dataWeaveEngine, new MuleConnectorLoaderFactory().create(),
          NameIdentifier.fromFQN("com::mulesoft::connectivity::mule::Metadata::MuleConnectorElement"));
  }
}
