/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.connectivity.mule.internal.metadata;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.weave.v2.ts.MetadataValue;

import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;

/**
 * Responsible for creating {@link DefaultValueAnnotation} from {@link MetadataValue}.
 */
public class DefaultValueAnnotationFactory implements TypeAnnotationFactory {

  public static final String ANNOTATION_DESCRIPTION = "The 'default value' metadata";
  public static final String DEFAULT_VALUE_ANNOTATION_KEY = "defaultValue";

  @Override
  public String getKey() {
    return DEFAULT_VALUE_ANNOTATION_KEY;
  }

  @Override
  public TypeAnnotation create(MetadataValue metadataValue) {
    return new DefaultValueAnnotation(MetadataValueUtils.asString(metadataValue, ANNOTATION_DESCRIPTION));
  }

}
