/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.connectivity.mule.internal.metadata;

import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.weave.v2.ts.MetadataValue;

import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;

/**
 * Responsible for creating {@link DescriptionAnnotation} from {@link MetadataValue}.
 */
public class DescriptionTypeAnnotationFactory implements TypeAnnotationFactory {

  public static final String ANNOTATION_DESCRIPTION = "The 'description' metadata";
  public static final String DESCRIPTION_ANNOTATION_KEY = "description";


  @Override
  public String getKey() {
    return DESCRIPTION_ANNOTATION_KEY;
  }

  @Override
  public TypeAnnotation create(MetadataValue metadataValue) {
    return new DescriptionAnnotation(MetadataValueUtils.asString(metadataValue, ANNOTATION_DESCRIPTION));
  }
}

