/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.connectivity.mule.internal.metadata;

import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.weave.v2.ts.MetadataValue;

import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;

/**
 * Responsible for creating {@link LabelAnnotation} from {@link MetadataValue}.
 */
public class LabelTypeAnnotationFactory implements TypeAnnotationFactory {

  public static final String ANNOTATION_DESCRIPTION = "The 'label' metadata";
  public static final String LABEL_ANNOTATION_KEY = "label";

  @Override
  public String getKey() {
    return LABEL_ANNOTATION_KEY;
  }

  @Override
  public TypeAnnotation create(MetadataValue metadataValue) {
    return new LabelAnnotation(MetadataValueUtils.asString(metadataValue, ANNOTATION_DESCRIPTION));
  }
}
