/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.connectivity.mule.internal.metadata;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.weave.v2.ts.MetadataValue;

/**
 * Responsible for creating {@link TypeAnnotation} instances from DataWeave metadata.
 */
public interface TypeAnnotationFactory {

  /**
   * Returns the key used in the DataWeave metadata to identify this annotation input data.
   *
   * @return the key
   */
  String getKey();

  /**
   * Creates a {@link TypeAnnotation} from the given metadata.
   *
   * @param metadataValue the metadata to create the annotation from
   * @return the new annotation object
   */
  TypeAnnotation create(MetadataValue metadataValue);
}
