/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.connectivity.mule.internal.model;

import static com.mulesoft.connectivity.mule.persistence.utils.ConnectorPropertyNames.AUTHENTICATION_TYPE_PROPERTY;
import static com.mulesoft.connectivity.mule.persistence.utils.ConnectorPropertyNames.INPUT_TYPE_PROPERTY;
import static com.mulesoft.connectivity.mule.persistence.utils.ConnectorPropertyNames.MODEL_REFERENCE_PROPERTY;
import static com.mulesoft.connectivity.mule.persistence.utils.ConnectorPropertyNames.NAME_PROPERTY;

import static java.util.Objects.requireNonNull;

import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;

import org.jspecify.annotations.Nullable;

/**
 * Represents a Mule ConnectionProvider.
 */
public class MuleConnectionProviderModel extends ConnectionProviderModel {


  protected MuleConnectionProviderModel(TypeModel inputType, @Nullable TestConnectionModel testConnection,
                                        AuthenticationType authenticationType, boolean hasExtensions,
                                        String name, String modelReference) {
    super(inputType, testConnection, authenticationType, hasExtensions, name, modelReference);
  }

  public static class Builder
      extends ConnectionProviderModel.AbstractConnectionBuilder<MuleConnectionProviderModel, Builder> {

    @Override
    protected MuleConnectionProviderModel createInstance() {
      return new MuleConnectionProviderModel(requireNonNull(inputType, INPUT_TYPE_PROPERTY + " must not be null"),
                                             testConnection,
                                             requireNonNull(authenticationType,
                                                            AUTHENTICATION_TYPE_PROPERTY + " must not be null"),
                                             hasExtensions, requireNonNull(name, NAME_PROPERTY + " must not be null"),
                                             requireNonNull(modelReference, MODEL_REFERENCE_PROPERTY + " must not be null"));
    }

    @Override
    protected Builder getThis() {
      return this;
    }

  }

  @Override
  public String toString() {
    return "MuleConnectionProviderModel{" +
        "inputType='" + inputType + '\'' +
        ", testConnection=" + testConnection +
        ", authenticationType=" + authenticationType +
        ", hasExtensions=" + hasExtensions +
        ", name=" + name +
        ", modelReference='" + modelReference + '\'' +
        '}';
  }
}
