/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package com.mulesoft.connectivity.mule.internal.persistence;

import org.mule.metadata.api.model.MetadataType;

import com.mulesoft.connectivity.mule.internal.model.MuleConnectorModel;
import com.mulesoft.connectivity.mule.internal.utils.MuleConnectorModelTransformer;
import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;

import java.io.StringWriter;
import java.io.Writer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * Serializes {@link MuleConnectorModel} from a serialized format as defined in {@link MuleConnectorSerializableModelTypeAdapter}.
 */
public class MuleModelSerializer {

  public String serialize(MuleConnectorModel model) {
    StringWriter writer = new StringWriter();
    MuleConnectorModelTransformer muleConnectorModelTransformer = new MuleConnectorModelTransformer();
    this.serialize(muleConnectorModelTransformer.toSerializableModel(model), writer);
    return writer.toString();
  }

  private void serialize(MuleConnectorSerializableModel model, Writer writer) {
    CatalogTypeCollector catalogCollector = new CatalogTypeCollector();
    Gson gson = new GsonBuilder()
        .registerTypeAdapter(MuleConnectorSerializableModel.class,
                             new MuleConnectorSerializableModelTypeAdapter(catalogCollector))
        .registerTypeAdapter(MetadataType.class, new MetadataTypeGsonTypeAdapterWithExternalCatalog(catalogCollector))
        .create();
    gson.toJson(model, writer);
  }

}
