/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.model;

import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectionProviderModel;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.ts.NullType;

public class MuleConnectionProviderModelTest {
    private static final TypeModel nullType = (TypeModel)new TypeModel.Builder().withDataType((DWType)new NullType()).build();

    @ParameterizedTest
    @MethodSource(value={"fieldProvider"})
    public void testMuleConnectionProviderModelBuilderWithout(String except) {
        MuleConnectionProviderModel.Builder builder = new MuleConnectionProviderModel.Builder();
        for (String field : MuleConnectionProviderModelTest.fieldProvider().collect(Collectors.toSet())) {
            if (field.equals(except)) continue;
            this.apply(builder, field);
        }
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> ((MuleConnectionProviderModel.Builder)builder).build());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)(except + " must not be null")));
    }

    @Test
    public void testConnectionProviderWithNullTestConnection() {
        MuleConnectionProviderModel.Builder builder = (MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)new MuleConnectionProviderModel.Builder().inputType(nullType)).name("connection")).withModelReference("modelRef")).authenticationType((AuthenticationType)new HttpAuthenticationType(HttpAuthenticationType.Type.basic, null));
        MuleConnectionProviderModel muleConnectionProviderModel = (MuleConnectionProviderModel)builder.build();
        Assertions.assertNotNull((Object)muleConnectionProviderModel);
        Assertions.assertNull((Object)muleConnectionProviderModel.getTestConnection());
        Assertions.assertFalse((boolean)muleConnectionProviderModel.getHasExtensions());
        MatcherAssert.assertThat((Object)muleConnectionProviderModel.getInputType(), (Matcher)Matchers.is((Object)nullType));
        MatcherAssert.assertThat((Object)((String)muleConnectionProviderModel.getModelReference().get()), (Matcher)Matchers.is((Object)"modelRef"));
        Assertions.assertNotNull((Object)muleConnectionProviderModel.getAuthenticationType());
        Assertions.assertInstanceOf(HttpAuthenticationType.class, (Object)muleConnectionProviderModel.getAuthenticationType());
    }

    static Stream<String> fieldProvider() {
        return Stream.of("inputType", "authenticationType", "modelReference", "name");
    }

    void apply(MuleConnectionProviderModel.Builder builder, String what) {
        switch (what) {
            case "inputType": {
                builder.inputType(nullType);
                break;
            }
            case "authenticationType": {
                builder.authenticationType((AuthenticationType)new HttpAuthenticationType(HttpAuthenticationType.Type.basic, null));
                break;
            }
            case "modelReference": {
                builder.withModelReference("modelReference");
                break;
            }
            case "name": {
                builder.name("connection");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown property: " + what);
            }
        }
    }
}

