/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.utils;

import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ContextReferenceVariable;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.model.provider.TypeReferenceExpression;
import com.mulesoft.connectivity.mule.internal.utils.ModelAPIToSerializedTransformer;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedContextReferenceVariable;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedObjectFieldSelector;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderArgument;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReference;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReferences;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class ModelAPIToSerializedTransformerTest {
    ModelAPIToSerializedTransformerTest() {
    }

    @Test
    @DisplayName(value="Should transform empty input resolved providers to empty map")
    void shouldTransformEmptyInputResolvedProvidersToEmptyMap() {
        HashMap input = new HashMap();
        Map result = ModelAPIToSerializedTransformer.transformResolvedProviders(input);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    @DisplayName(value="Should transform provider references with value provider only")
    void shouldTransformProviderReferencesWithValueProviderOnly() {
        ObjectFieldSelector fieldSelector = ObjectFieldSelector.create((String)"/recordId");
        ProviderReference valueProviderRef = new ProviderReference("testProvider", Collections.emptyList());
        ExecutableComponentModel.ProviderReferences providerRefs = new ExecutableComponentModel.ProviderReferences(valueProviderRef, null);
        HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> input = new HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences>();
        input.put(fieldSelector, providerRefs);
        Map result = ModelAPIToSerializedTransformer.transformResolvedProviders(input);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        SerializedProviderReferences serializedRefs = (SerializedProviderReferences)result.entrySet().stream().filter(entry -> Arrays.equals(((SerializedObjectFieldSelector)entry.getKey()).getPath(), new String[]{"recordId"})).findFirst().orElseThrow().getValue();
        MatcherAssert.assertThat((Object)serializedRefs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        SerializedProviderReference serializedValueProvider = serializedRefs.getValueProviderReference();
        MatcherAssert.assertThat((Object)serializedValueProvider, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)serializedValueProvider.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"testProvider")));
        MatcherAssert.assertThat((Object)serializedValueProvider.getArguments(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)serializedRefs.getMetadataProviderReference(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    @DisplayName(value="Should transform provider references with arguments")
    void shouldTransformProviderReferencesWithArguments() {
        ObjectFieldSelector fieldSelector = ObjectFieldSelector.create((String)"/recordId");
        ObjectFieldSelector paramSelector = ObjectFieldSelector.create((String)"state");
        ContextReferenceVariable inputSelector = new ContextReferenceVariable("inputVar");
        ProviderArgument argument = new ProviderArgument(paramSelector, (TypeReferenceExpression)inputSelector);
        ProviderReference valueProviderRef = new ProviderReference("testProvider", Arrays.asList(argument));
        ExecutableComponentModel.ProviderReferences providerRefs = new ExecutableComponentModel.ProviderReferences(valueProviderRef, null);
        HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> input = new HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences>();
        input.put(fieldSelector, providerRefs);
        Map result = ModelAPIToSerializedTransformer.transformResolvedProviders(input);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        SerializedProviderReferences serializedRefs = (SerializedProviderReferences)result.entrySet().stream().filter(entry -> Arrays.equals(((SerializedObjectFieldSelector)entry.getKey()).getPath(), new String[]{"recordId"})).findFirst().orElseThrow().getValue();
        MatcherAssert.assertThat((Object)serializedRefs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        SerializedProviderReference serializedValueProvider = serializedRefs.getValueProviderReference();
        MatcherAssert.assertThat((Object)serializedValueProvider, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)serializedValueProvider.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"testProvider")));
        MatcherAssert.assertThat((Object)serializedValueProvider.getArguments(), (Matcher)Matchers.hasSize((int)1));
        SerializedProviderArgument serializedArgument = (SerializedProviderArgument)serializedValueProvider.getArguments().get(0);
        MatcherAssert.assertThat((Object)serializedArgument.getParameterSelector(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)serializedArgument.getParameterSelector().isRelative(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)serializedArgument.getParameterSelector().getPath(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)new String[]{"state"})));
        MatcherAssert.assertThat((Object)serializedArgument.getInputSelector(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)serializedArgument.getInputSelector(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(SerializedContextReferenceVariable.class)));
        SerializedContextReferenceVariable serializedInputSelector = (SerializedContextReferenceVariable)serializedArgument.getInputSelector();
        MatcherAssert.assertThat((Object)serializedInputSelector.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"inputVar")));
    }

    @Test
    @DisplayName(value="Should transform multiple field selectors with different providers")
    void shouldTransformMultipleFieldSelectorsWithDifferentProviders() {
        ObjectFieldSelector fieldSelector1 = ObjectFieldSelector.create((String)"/recordId");
        ObjectFieldSelector fieldSelector2 = ObjectFieldSelector.create((String)"/name");
        ProviderReference valueProviderRef1 = new ProviderReference("provider1", Collections.emptyList());
        ProviderReference valueProviderRef2 = new ProviderReference("provider2", Collections.emptyList());
        ExecutableComponentModel.ProviderReferences providerRefs1 = new ExecutableComponentModel.ProviderReferences(valueProviderRef1, null);
        ExecutableComponentModel.ProviderReferences providerRefs2 = new ExecutableComponentModel.ProviderReferences(valueProviderRef2, null);
        HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> input = new HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences>();
        input.put(fieldSelector1, providerRefs1);
        input.put(fieldSelector2, providerRefs2);
        Map result = ModelAPIToSerializedTransformer.transformResolvedProviders(input);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
        SerializedProviderReferences serializedRefs1 = (SerializedProviderReferences)result.entrySet().stream().filter(entry -> Arrays.equals(((SerializedObjectFieldSelector)entry.getKey()).getPath(), new String[]{"recordId"})).findFirst().orElseThrow().getValue();
        SerializedProviderReferences serializedRefs2 = (SerializedProviderReferences)result.entrySet().stream().filter(entry -> Arrays.equals(((SerializedObjectFieldSelector)entry.getKey()).getPath(), new String[]{"name"})).findFirst().orElseThrow().getValue();
        MatcherAssert.assertThat((Object)serializedRefs1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)serializedRefs2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)serializedRefs1.getValueProviderReference().getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"provider1")));
        MatcherAssert.assertThat((Object)serializedRefs2.getValueProviderReference().getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"provider2")));
    }

    @Test
    @DisplayName(value="Should throw exception for unsupported type reference expression")
    void shouldThrowExceptionForUnsupportedTypeReferenceExpression() {
        TypeReferenceExpression unsupportedTypeRef = new TypeReferenceExpression(){

            public String toString() {
                return "UnsupportedTypeRef";
            }
        };
        ObjectFieldSelector fieldSelector = ObjectFieldSelector.create((String)"/recordId");
        ProviderArgument argument = new ProviderArgument(fieldSelector, unsupportedTypeRef);
        ProviderReference valueProviderRef = new ProviderReference("testProvider", Arrays.asList(argument));
        ExecutableComponentModel.ProviderReferences providerRefs = new ExecutableComponentModel.ProviderReferences(valueProviderRef, null);
        HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> input = new HashMap<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences>();
        input.put(fieldSelector, providerRefs);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ModelAPIToSerializedTransformer.transformResolvedProviders((Map)input));
    }
}

