/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.persistence;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonWriter;
import com.mulesoft.connectivity.mule.internal.persistence.CatalogTypeCollector;
import com.mulesoft.connectivity.mule.internal.persistence.ExternalCatalogObjectTypeReferenceHandler;
import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.serializer.ObjectTypeSerializer;
import org.mule.metadata.persistence.serializer.TypeSerializer;
import org.mule.metadata.persistence.serializer.TypeSerializerVisitor;

public class MuleConnectorSerializableModelTypeAdapter
implements JsonSerializer<MuleConnectorSerializableModel> {
    private final CatalogTypeCollector catalogCollector;

    public MuleConnectorSerializableModelTypeAdapter(CatalogTypeCollector catalogCollector) {
        this.catalogCollector = catalogCollector;
    }

    public JsonElement serialize(MuleConnectorSerializableModel src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.addProperty("name", src.getName());
        result.addProperty("displayName", src.getDisplayName());
        result.addProperty("version", src.getVersion());
        result.addProperty("category", src.getCategory().toString());
        result.addProperty("description", src.getDescription());
        result.addProperty("vendor", src.getVendor());
        String modelReference = (String)src.getModelReference().orElseThrow(() -> new NoSuchElementException("Connector model does not have a DataWeave model reference!"));
        result.addProperty("modelReference", modelReference);
        result.add("connections", context.serialize((Object)src.getConnections()));
        result.add("testConnection", context.serialize((Object)src.getTestConnection()));
        result.add("operations", context.serialize((Object)src.getOperations()));
        result.add("sources", context.serialize((Object)src.getSources()));
        result.add("valueProviders", context.serialize((Object)src.getValueProviders()));
        result.add("catalog", this.serializeCatalog());
        return result;
    }

    private JsonElement serializeCatalog() {
        JsonElement jsonElement;
        Stack typeStack = new Stack();
        Map<String, ObjectType> registeredTypes = this.catalogCollector.getCatalog();
        ExternalCatalogObjectTypeReferenceHandler referenceHandler = new ExternalCatalogObjectTypeReferenceHandler(this.catalogCollector);
        JsonTreeWriter writer = new JsonTreeWriter();
        try {
            writer.beginObject();
            registeredTypes.forEach((id, type) -> {
                try {
                    writer.name(id);
                    TypeSerializerVisitor visitor = new TypeSerializerVisitor((JsonWriter)writer, referenceHandler, new Stack(), false);
                    new ObjectTypeSerializer((TypeSerializer)visitor).serialize((JsonWriter)writer, (MetadataType)type, typeStack);
                }
                catch (Exception e) {
                    throw new MetadataSerializingException("Object MetadataType for catalog", e);
                }
            });
            writer.endObject();
            writer.flush();
            jsonElement = writer.get();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MetadataSerializingException("Failed to serialize catalog", (Exception)e);
            }
        }
        writer.close();
        return jsonElement;
    }
}

