/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.metadata;

import com.mulesoft.connectivity.linkweave.api.loader.InvalidConnectorException;
import com.mulesoft.connectivity.mule.internal.metadata.TypeAnnotationFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.weave.v2.ts.KeyValuePairMetadataValue;
import org.mule.weave.v2.ts.MetadataValue;

public abstract class TypeAnnotationFactoryTest {
    protected TypeAnnotationFactory typeAnnotationFactory;

    protected abstract String getAnnotationKey();

    protected abstract void assertAnnotationValue(TypeAnnotation var1, Object var2);

    @Test
    public void testTypeAnnotationKey() {
        MatcherAssert.assertThat((Object)this.typeAnnotationFactory.getKey(), (Matcher)Matchers.is((Object)this.getAnnotationKey()));
    }

    @Test
    public void testAnnotationWithNullMetadata() {
        NullPointerException nullPointerException = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> this.typeAnnotationFactory.create(null));
        Assertions.assertEquals((Object)"Cannot invoke \"Object.getClass()\" because \"metadataValue\" is null", (Object)nullPointerException.getMessage());
    }

    protected void assertAnnotationFactory(MetadataValue metadataValue, Object expectedValue, Class<? extends TypeAnnotation> annotationClass) {
        TypeAnnotation typeAnnotation = this.typeAnnotationFactory.create(metadataValue);
        MatcherAssert.assertThat(typeAnnotation.getClass(), (Matcher)Matchers.is(annotationClass));
        MatcherAssert.assertThat((Object)typeAnnotation.getName(), (Matcher)Matchers.is((Object)this.getAnnotationKey()));
        this.assertAnnotationValue(typeAnnotation, expectedValue);
    }

    protected void assertAnnotationWithNonStringLiteralType(String expectedMessage) {
        KeyValuePairMetadataValue metadataValue = new KeyValuePairMetadataValue("MetadataKey", null, null);
        InvalidConnectorException invalidConnectorException = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> this.lambda$assertAnnotationWithNonStringLiteralType$1((MetadataValue)metadataValue));
        Assertions.assertEquals((Object)expectedMessage, (Object)invalidConnectorException.getMessage());
    }

    private /* synthetic */ void lambda$assertAnnotationWithNonStringLiteralType$1(MetadataValue metadataValue) throws Throwable {
        this.typeAnnotationFactory.create(metadataValue);
    }
}

