/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.loader;

import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.DataWeaveReference;
import com.mulesoft.connectivity.linkweave.api.loader.ConnectorLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectionProviderModel;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectorModel;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullUnmarked;
import org.mule.runtime.api.meta.Category;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class MuleConnectorLoader
extends ConnectorLoader<MuleConnectorModel, MuleConnectorModel.Builder, DataWeaveObjectReference> {
    private final ModelLoader<TestConnectionModel, TestConnectionModel.Builder, DataWeaveObjectReference> testConnectionLoader;
    private final ModelLoader<MuleConnectionProviderModel, MuleConnectionProviderModel.Builder, DataWeaveObjectReference> connectionProviderLoader;
    private final ModelLoader<OperationModel, OperationModel.Builder, DataWeaveObjectReference> operationLoader;
    private final ModelLoader<TriggerModel, TriggerModel.Builder, DataWeaveObjectReference> triggerLoader;
    private final ModelLoader<ValueProviderModel, ValueProviderModel.Builder, DataWeaveReference<?>> valueProviderLoader;

    public MuleConnectorLoader(ModelLoader<MuleConnectionProviderModel, MuleConnectionProviderModel.Builder, DataWeaveObjectReference> connectionProviderLoader, ModelLoader<TestConnectionModel, TestConnectionModel.Builder, DataWeaveObjectReference> testConnectionLoader, ModelLoader<OperationModel, OperationModel.Builder, DataWeaveObjectReference> operationLoader, ModelLoader<TriggerModel, TriggerModel.Builder, DataWeaveObjectReference> triggerLoader, ModelLoader<ValueProviderModel, ValueProviderModel.Builder, DataWeaveReference<?>> valueProviderLoader) {
        this.connectionProviderLoader = connectionProviderLoader;
        this.testConnectionLoader = testConnectionLoader;
        this.operationLoader = operationLoader;
        this.triggerLoader = triggerLoader;
        this.valueProviderLoader = valueProviderLoader;
    }

    protected MuleConnectorModel.Builder createBuilder() {
        return new MuleConnectorModel.Builder();
    }

    @NullUnmarked
    protected MuleConnectorModel.Builder configureBuilder(MuleConnectorModel.Builder builder, DataWeaveObjectReference connectorObject, String name) {
        if (!(connectorObject.getType() instanceof ObjectType)) {
            throw new IllegalStateException("Invalid connector type. Expected Object but " + String.valueOf(connectorObject.getType().getBaseType()) + " found");
        }
        connectorObject.getProperty("name").map(DataWeaveReference::asString).ifPresent(arg_0 -> ((MuleConnectorModel.Builder)builder).withName(arg_0));
        connectorObject.getProperty("displayName").map(DataWeaveReference::asString).ifPresent(arg_0 -> ((MuleConnectorModel.Builder)builder).withDisplayName(arg_0));
        connectorObject.getProperty("version").map(DataWeaveReference::asString).ifPresent(builder::withVersion);
        connectorObject.getProperty("description").map(DataWeaveReference::asString).ifPresent(builder::withDescription);
        connectorObject.getProperty("vendor").map(DataWeaveReference::asString).ifPresent(builder::withVendor);
        connectorObject.getProperty("category").map(DataWeaveReference::asString).ifPresent(category -> builder.withCategory(Category.valueOf((String)category.toUpperCase())));
        builder.withModelReference(connectorObject.getPath());
        builder.withConnections(connectorObject.requireObjectProperty("connections").properties().map(e -> (MuleConnectionProviderModel)this.connectionProviderLoader.loadModel((DataWeaveReference)((DataWeaveReference)e.getValue()).asObjectReference(), (String)e.getKey())).collect(Collectors.toUnmodifiableList()));
        connectorObject.getObjectProperty("testConnection").ifPresent(tc -> builder.withTestConnection((TestConnectionModel)this.testConnectionLoader.loadModel((DataWeaveReference)tc, name)));
        builder.withOperations(connectorObject.requireObjectProperty("operations").properties().map(e -> (OperationModel)this.operationLoader.loadModel((DataWeaveReference)((DataWeaveReference)e.getValue()).asObjectReference(), null)).toList());
        builder.withTriggers(connectorObject.getObjectProperty("triggers").stream().flatMap(DataWeaveObjectReference::properties).map(e -> (TriggerModel)this.triggerLoader.loadModel((DataWeaveReference)((DataWeaveReference)e.getValue()).asObjectReference(), (String)e.getKey())).toList());
        connectorObject.getObjectProperty("valueProviders").ifPresent(vp -> builder.withValueProviders(vp.properties().map(e -> (ValueProviderModel)this.valueProviderLoader.loadModel((DataWeaveReference)e.getValue(), (String)e.getKey())).collect(Collectors.toList())));
        return builder;
    }
}

