/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.utils;

import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ContextReferenceVariable;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderArgument;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.model.provider.TypeReferenceExpression;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedContextReferenceVariable;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedObjectFieldSelector;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderArgument;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReference;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReferences;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedTypeReferenceExpression;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModelAPIToSerializedTransformer {
    private ModelAPIToSerializedTransformer() {
    }

    public static Map<SerializedObjectFieldSelector, SerializedProviderReferences> transformResolvedProviders(Map<ObjectFieldSelector, ExecutableComponentModel.ProviderReferences> modelApiProviders) {
        return modelApiProviders.entrySet().stream().collect(Collectors.toMap(entry -> ModelAPIToSerializedTransformer.transformObjectFieldSelector((ObjectFieldSelector)entry.getKey()), entry -> ModelAPIToSerializedTransformer.transformProviderReferences((ExecutableComponentModel.ProviderReferences)entry.getValue())));
    }

    private static SerializedProviderReferences transformProviderReferences(ExecutableComponentModel.ProviderReferences modelApiProviderReferences) {
        return new SerializedProviderReferences(ModelAPIToSerializedTransformer.transformProviderReference(modelApiProviderReferences.getValueProviderReference()), ModelAPIToSerializedTransformer.transformProviderReference(modelApiProviderReferences.getMetadataProviderReference()));
    }

    private static SerializedProviderReference transformProviderReference(ProviderReference modelApiProviderReference) {
        if (modelApiProviderReference == null) {
            return null;
        }
        List arguments = modelApiProviderReference.getArguments().stream().map(ModelAPIToSerializedTransformer::transformProviderArgument).collect(Collectors.toList());
        return new SerializedProviderReference(modelApiProviderReference.getName(), arguments);
    }

    private static SerializedProviderArgument transformProviderArgument(ProviderArgument modelApiProviderArgument) {
        return new SerializedProviderArgument(ModelAPIToSerializedTransformer.transformObjectFieldSelector(modelApiProviderArgument.getParameterSelector()), ModelAPIToSerializedTransformer.transformTypeReferenceExpression(modelApiProviderArgument.getInputSelector()));
    }

    private static SerializedObjectFieldSelector transformObjectFieldSelector(ObjectFieldSelector modelApiSelector) {
        if (modelApiSelector.getPath().length > 1) {
            throw new RuntimeException("Nested Providers not allowed: " + String.join((CharSequence)".", modelApiSelector.getPath()));
        }
        return new SerializedObjectFieldSelector(modelApiSelector.isRelative(), modelApiSelector.getPath());
    }

    private static SerializedTypeReferenceExpression transformTypeReferenceExpression(TypeReferenceExpression modelApiTypeRef) {
        if (modelApiTypeRef instanceof ContextReferenceVariable) {
            ContextReferenceVariable contextVar = (ContextReferenceVariable)modelApiTypeRef;
            return new SerializedContextReferenceVariable(contextVar.getName());
        }
        if (modelApiTypeRef instanceof ObjectFieldSelector) {
            ObjectFieldSelector objectFieldSelector = (ObjectFieldSelector)modelApiTypeRef;
            return new SerializedObjectFieldSelector(objectFieldSelector.isRelative(), objectFieldSelector.getPath());
        }
        throw new IllegalArgumentException("Unknown type reference expression: " + String.valueOf(modelApiTypeRef.getClass()));
    }
}

