/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.persistence;

import com.google.gson.stream.JsonWriter;
import com.mulesoft.connectivity.mule.persistence.serialize.ReferenceResolver;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;

public class ExternalCatalogObjectTypeReferenceHandler
implements ObjectTypeReferenceHandler {
    private final ReferenceResolver referenceResolver;

    public ExternalCatalogObjectTypeReferenceHandler(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public Optional<TypeBuilder> readReference(String typeReference) {
        return Optional.empty();
    }

    public Optional<String> writeReference(ObjectType type, JsonWriter writer) {
        Objects.requireNonNull(this.referenceResolver, "Tried to write a reference on a read-only handler");
        Optional referenceOptional = this.referenceResolver.getIdentifier(type);
        if (referenceOptional.isPresent()) {
            String reference = (String)referenceOptional.get();
            try {
                writer.name("type").value("@ref:" + reference);
            }
            catch (IOException e) {
                throw new MetadataSerializingException("MetadataType reference [" + reference + "]", (Exception)e);
            }
        }
        return referenceOptional;
    }
}

