/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.utils;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.model.MetadataKey;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.mule.internal.utils.MuleTypeTransformer;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.ts.LiteralMetadataValue;
import org.mule.weave.v2.ts.Metadata;
import org.mule.weave.v2.ts.MetadataValue;
import org.mule.weave.v2.ts.StringType;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;

public class MuleTypeTransformerTest {
    private static final String OBJECT = "Object";
    private static final String NUMBER = "Number";
    private static final WeaveType wt = (WeaveType)Mockito.mock(WeaveType.class);

    @Test
    public void testMuleTypeTransformerWithAnnotation() {
        Metadata metadata;
        Map<String, String> field = Map.of("name", Map.of("localName", "orderId"), "required", true, "repeated", false, "value", Map.of("type", NUMBER, "label", "valueLabel"), "label", "keyLabel", "description", "Description");
        DWType objectDefinitionType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", OBJECT, "name", "Order", "fields", List.of(field)));
        if (field.get("label") != null) {
            metadata = new Metadata(MetadataKey.LABEL.getKey(), (MetadataValue)new LiteralMetadataValue(field.get("label"), (WeaveType)new StringType(Option.empty()), null), null);
            ((WeaveType)objectDefinitionType).withMetadata(metadata);
        }
        if (field.get("description") != null) {
            metadata = new Metadata(MetadataKey.DESCRIPTION.getKey(), (MetadataValue)new LiteralMetadataValue(field.get("description"), (WeaveType)new StringType(Option.empty()), null), null);
            ((WeaveType)objectDefinitionType).withMetadata(metadata);
        }
        MatcherAssert.assertThat((Object)objectDefinitionType, (Matcher)Matchers.instanceOf(org.mule.weave.v2.ts.ObjectType.class));
        TypeModel inputType = (TypeModel)new TypeModel.Builder().withDataType(objectDefinitionType).build();
        MetadataType muleTypeWithAnnotations = new MuleTypeTransformer().toMuleTypeWithAnnotations((WeaveType)inputType.getDataType());
        MatcherAssert.assertThat((Object)muleTypeWithAnnotations, (Matcher)Matchers.instanceOf(ObjectType.class));
        ObjectFieldType objectFieldType = (ObjectFieldType)((ObjectType)muleTypeWithAnnotations).getFields().stream().findFirst().get();
        MatcherAssert.assertThat((Object)objectFieldType.getKey().getName().getLocalPart(), (Matcher)Matchers.is((Object)"orderId"));
        Assertions.assertTrue((boolean)objectFieldType.isRequired());
        Assertions.assertFalse((boolean)objectFieldType.isRepeated());
        MatcherAssert.assertThat((Object)muleTypeWithAnnotations.getAnnotations().size(), (Matcher)Matchers.is((Object)2));
        TypeAnnotation labelAnnotation = muleTypeWithAnnotations.getAnnotations().stream().filter(value -> value instanceof LabelAnnotation).findFirst().get();
        MatcherAssert.assertThat((Object)((LabelAnnotation)labelAnnotation).getValue(), (Matcher)Matchers.is((Object)"keyLabel"));
        TypeAnnotation descriptionAnnotation = muleTypeWithAnnotations.getAnnotations().stream().filter(value -> value instanceof DescriptionAnnotation).findFirst().get();
        MatcherAssert.assertThat((Object)((DescriptionAnnotation)descriptionAnnotation).getValue(), (Matcher)Matchers.is((Object)"Description"));
    }
}

