/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.utils;

import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthCodeAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.operation.ErrorModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectionProviderModel;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectorModel;
import com.mulesoft.connectivity.mule.internal.utils.ModelAPIToSerializedTransformer;
import com.mulesoft.connectivity.mule.internal.utils.MuleTypeTransformer;
import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleErrorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleOperationSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleSourceSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleValueProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleTestConnectionSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.runtime.api.meta.Category;
import org.mule.weave.v2.ts.TypeParameter;
import org.mule.weave.v2.ts.WeaveType;

public class MuleConnectorModelTransformer {
    private final MuleTypeTransformer muleTypeTransformer = new MuleTypeTransformer();
    private static final Set<String> CUSTOM_INPUT_FIELDS = Set.of("customHeaders", "customQueryParams");
    private static final String GENERIC_ERROR_TYPE_FIELD = "ErrorType";

    private Supplier<? extends RuntimeException> shouldHaveRef(String kind) {
        return () -> new NoSuchElementException("Every " + kind + " should have a model reference");
    }

    public MuleConnectorSerializableModel toSerializableModel(MuleConnectorModel muleConnectorModel) {
        return ((MuleConnectorSerializableModel.Builder)MuleConnectorSerializableModel.builder().name(muleConnectorModel.getName()).displayName(muleConnectorModel.getDisplayName()).version(muleConnectorModel.getVersion()).description(muleConnectorModel.getDescription()).vendor(muleConnectorModel.getVendor()).category(Category.valueOf((String)muleConnectorModel.getCategory().name())).connectionProviders(muleConnectorModel.getConnections().stream().map(this::toSerializableConnectionProvider).toList()).testConnection(this.toSerializableTestConnection(muleConnectorModel.getTestConnection())).operations(muleConnectorModel.getOperations().stream().map(this::toSerializableOperation).toList()).sources(muleConnectorModel.getTriggers().stream().map(this::toSerializableSource).toList()).modelReference((String)muleConnectorModel.getModelReference().orElseThrow(this.shouldHaveRef("connector")))).valueProviders(muleConnectorModel.getValueProviders().stream().map(this::toSerializableValueProvider).toList()).build();
    }

    private MuleTestConnectionSerializableModel toSerializableTestConnection(TestConnectionModel testConnectionModel) {
        if (testConnectionModel != null) {
            return ((MuleTestConnectionSerializableModel.Builder)MuleTestConnectionSerializableModel.builder().modelReference((String)testConnectionModel.getModelReference().orElseThrow(this.shouldHaveRef("test connection")))).build();
        }
        return null;
    }

    private MuleConnectionProviderSerializableModel toSerializableConnectionProvider(MuleConnectionProviderModel muleConnectionProviderModel) {
        return ((MuleConnectionProviderSerializableModel.Builder)MuleConnectionProviderSerializableModel.builder().inputType(this.muleTypeTransformer.toMuleTypeWithAnnotations((WeaveType)muleConnectionProviderModel.getInputType().getDataType())).testConnection(this.toSerializableTestConnection(muleConnectionProviderModel.getTestConnection())).authenticationType(this.toSerializableAuthType(muleConnectionProviderModel.getAuthenticationType())).hasExtensions(muleConnectionProviderModel.getHasExtensions()).modelReference((String)muleConnectionProviderModel.getModelReference().orElseThrow(this.shouldHaveRef("connection provider")))).name(muleConnectionProviderModel.getName()).build();
    }

    private MuleOperationSerializableModel toSerializableOperation(OperationModel operationModel) {
        return ((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)MuleOperationSerializableModel.builder().inputType(this.transformOperationInputType((WeaveType)operationModel.getInputType().getDataType()))).outputType(this.muleTypeTransformer.toMuleTypeWithAnnotations((WeaveType)operationModel.getOutputType().getDataType()))).name(operationModel.getName())).displayName(operationModel.getDisplayName())).errorOutputType(this.muleTypeTransformer.toMuleTypeWithAnnotations((WeaveType)operationModel.getErrorOutputType().getDataType()))).isPaginated(operationModel.isPaginated())).errorModelList(operationModel.getErrorDefinitions().stream().map(this::toSerializableErrorModel).toList())).inputResolvedProviders(ModelAPIToSerializedTransformer.transformResolvedProviders(operationModel.getInputResolvedProviders()))).outputResolvedProviders(ModelAPIToSerializedTransformer.transformResolvedProviders(operationModel.getOutputResolvedProviders()))).modelReference((String)operationModel.getModelReference().orElseThrow(this.shouldHaveRef("operation")))).build();
    }

    private MetadataType transformWeaveTypeWithFieldProcessing(WeaveType weaveType, Function<ObjectFieldType, MetadataType> fieldProcessor) {
        MetadataType baseType = this.muleTypeTransformer.toMuleTypeWithAnnotations(weaveType);
        if (!(baseType instanceof ObjectType)) {
            return baseType;
        }
        ObjectType objectType = (ObjectType)baseType;
        return this.transformObjectTypeWithFieldProcessing(objectType, fieldProcessor);
    }

    private MetadataType transformObjectTypeWithFieldProcessing(ObjectType objectType, Function<ObjectFieldType, MetadataType> fieldProcessor) {
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
        ObjectTypeBuilder objectBuilder = typeBuilder.objectType();
        objectType.getAnnotations().forEach(arg_0 -> ((ObjectTypeBuilder)objectBuilder).with(arg_0));
        for (ObjectFieldType field : objectType.getFields()) {
            ObjectFieldTypeBuilder fieldBuilder = objectBuilder.addField();
            fieldBuilder.key(field.getKey().getName());
            MetadataType fieldType = fieldProcessor.apply(field);
            fieldBuilder.value(fieldType);
            fieldBuilder.required(field.isRequired());
            fieldBuilder.repeated(field.isRepeated());
            field.getKey().getAnnotations().forEach(arg_0 -> ((ObjectFieldTypeBuilder)fieldBuilder).withKeyAnnotation(arg_0));
            field.getAnnotations().forEach(arg_0 -> ((ObjectFieldTypeBuilder)fieldBuilder).with(arg_0));
        }
        return objectBuilder.build();
    }

    private MetadataType transformTypeParameter(WeaveType weaveType) {
        if (weaveType instanceof TypeParameter) {
            return MuleTypeTransformer.toMapMuleType();
        }
        return this.transformWeaveTypeWithFieldProcessing(weaveType, field -> {
            MetadataType fieldType = field.getValue();
            if (fieldType instanceof ObjectType) {
                ObjectType fieldObjectType = (ObjectType)fieldType;
                fieldType = this.transformObjectTypeWithFieldProcessing(fieldObjectType, nestedField -> {
                    TypeParameterType typeParameterType;
                    MetadataType nestedFieldValue = nestedField.getValue();
                    if (nestedFieldValue instanceof TypeParameterType && (typeParameterType = (TypeParameterType)nestedFieldValue).getName().equals(GENERIC_ERROR_TYPE_FIELD)) {
                        return MuleTypeTransformer.toMapMuleType();
                    }
                    return nestedFieldValue;
                });
            }
            return fieldType;
        });
    }

    private MetadataType transformOperationInputType(WeaveType weaveType) {
        return this.transformWeaveTypeWithFieldProcessing(weaveType, field -> {
            if (CUSTOM_INPUT_FIELDS.contains(field.getKey().getName().getLocalPart())) {
                return MuleTypeTransformer.toMapMuleType();
            }
            return field.getValue();
        });
    }

    private MuleSourceSerializableModel toSerializableSource(TriggerModel triggerModel) {
        return ((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)MuleSourceSerializableModel.builder().inputType(this.muleTypeTransformer.toMuleTypeWithAnnotations((WeaveType)triggerModel.getInputType().getDataType()))).outputType(this.muleTypeTransformer.toMuleTypeWithAnnotations((WeaveType)triggerModel.getOutputType().getDataType()))).name(triggerModel.getName())).displayName(triggerModel.getDisplayName())).errorOutputType(this.muleTypeTransformer.toMuleTypeWithAnnotations((WeaveType)triggerModel.getErrorOutputType().getDataType()))).isPaginated(triggerModel.isPaginated())).errorModelList(triggerModel.getErrorDefinitions().stream().map(this::toSerializableErrorModel).toList())).inputResolvedProviders(ModelAPIToSerializedTransformer.transformResolvedProviders(triggerModel.getInputResolvedProviders()))).outputResolvedProviders(ModelAPIToSerializedTransformer.transformResolvedProviders(triggerModel.getOutputResolvedProviders()))).modelReference((String)triggerModel.getModelReference().orElseThrow(this.shouldHaveRef("trigger")))).build();
    }

    private MuleValueProviderSerializableModel toSerializableValueProvider(ValueProviderModel valueProviderModel) {
        return ((MuleValueProviderSerializableModel.Builder)MuleValueProviderSerializableModel.builder().name(valueProviderModel.getName()).isPaginated(valueProviderModel.isPaginated()).modelReference((String)valueProviderModel.getModelReference().orElse(null))).inputType(this.transformTypeParameter((WeaveType)valueProviderModel.getInputType().getDataType())).providedValueType(this.transformTypeParameter((WeaveType)valueProviderModel.getProvidedValueType().getDataType())).errorOutputType(this.transformTypeParameter((WeaveType)valueProviderModel.getErrorOutputType().getDataType())).displayPropertiesType(this.transformTypeParameter((WeaveType)valueProviderModel.getDisplayPropertiesType().getDataType())).build();
    }

    private MuleErrorSerializableModel toSerializableErrorModel(ErrorModel errorModel) {
        return MuleErrorSerializableModel.builder().errorType(this.muleTypeTransformer.toMuleTypeWithAnnotations((WeaveType)errorModel.getErrorType().getDataType())).kind(errorModel.getKind()).categories(errorModel.getCategories()).build();
    }

    private com.mulesoft.connectivity.mule.persistence.model.connection.HttpAuthenticationType toSerializableAuthType(AuthenticationType authenticationType) {
        if (authenticationType instanceof OAuth2AuthCodeAuthenticationType) {
            OAuth2AuthCodeAuthenticationType oAuth2AuthCodeAuthenticationType = (OAuth2AuthCodeAuthenticationType)authenticationType;
            return new com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2AuthCodeAuthenticationType(oAuth2AuthCodeAuthenticationType.getRefreshUrl(), oAuth2AuthCodeAuthenticationType.getScopes(), oAuth2AuthCodeAuthenticationType.getAuthorizationUrl(), oAuth2AuthCodeAuthenticationType.getTokenUrl());
        }
        if (authenticationType instanceof com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType) {
            com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType oAuth2ClientCredentialsAuthenticationType = (com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType)authenticationType;
            return new OAuth2ClientCredentialsAuthenticationType(oAuth2ClientCredentialsAuthenticationType.getRefreshUrl(), oAuth2ClientCredentialsAuthenticationType.getScopes(), oAuth2ClientCredentialsAuthenticationType.getTokenUrl());
        }
        if (authenticationType instanceof ApiKeyHttpAuthenticationType) {
            ApiKeyHttpAuthenticationType apiKeyHttpAuthenticationType = (ApiKeyHttpAuthenticationType)authenticationType;
            return new com.mulesoft.connectivity.mule.persistence.model.connection.ApiKeyHttpAuthenticationType((String)apiKeyHttpAuthenticationType.getSubType().orElse(null), ApiKeyHttpAuthenticationType.In.fromString((String)apiKeyHttpAuthenticationType.getIn().toString()), apiKeyHttpAuthenticationType.getName());
        }
        if (authenticationType instanceof HttpAuthenticationType) {
            HttpAuthenticationType httpAuthenticationType = (HttpAuthenticationType)authenticationType;
            return new com.mulesoft.connectivity.mule.persistence.model.connection.HttpAuthenticationType(HttpAuthenticationType.Type.fromString((String)httpAuthenticationType.getType().toString()), (String)httpAuthenticationType.getSubType().orElse(null));
        }
        throw new RuntimeException("Unsupported authenticationType: " + authenticationType.getClass().getName());
    }
}

