/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.utils;

import com.mulesoft.connectivity.mule.internal.metadata.DefaultValueAnnotationFactory;
import com.mulesoft.connectivity.mule.internal.metadata.DescriptionTypeAnnotationFactory;
import com.mulesoft.connectivity.mule.internal.metadata.FormatAnnotationFactory;
import com.mulesoft.connectivity.mule.internal.metadata.LabelTypeAnnotationFactory;
import com.mulesoft.connectivity.mule.internal.metadata.SemanticTermsTypeAnnotationFactory;
import com.mulesoft.connectivity.mule.internal.metadata.TypeAnnotationFactory;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.weave.v2.metadata.api.MetadataModelConverter;
import org.mule.weave.v2.metadata.api.MetadataModelConverterConfig;
import org.mule.weave.v2.metadata.api.WeaveTypeMetadataConvert;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;
import scala.Predef;
import scala.collection.JavaConverters;
import scala.collection.immutable.Map;

public class MuleTypeTransformer {
    private final MetadataModelConverter metadataModelConverter;

    public MuleTypeTransformer() {
        java.util.Map<String, TypeAnnotationFactory> annotationFactories = this.getAnnotationFactories();
        WeaveTypeMetadataConvert weaveTypeMetadataConvert = metadata -> {
            TypeAnnotationFactory factory = (TypeAnnotationFactory)annotationFactories.get(metadata.name());
            return factory != null ? factory.create(metadata.value()) : null;
        };
        MetadataModelConverterConfig config = MetadataModelConverterConfig.apply((boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (Option)Option.apply((Object)weaveTypeMetadataConvert));
        this.metadataModelConverter = new MetadataModelConverter(config);
    }

    private java.util.Map<String, TypeAnnotationFactory> getAnnotationFactories() {
        return Stream.of(new DescriptionTypeAnnotationFactory(), new LabelTypeAnnotationFactory(), new FormatAnnotationFactory(), new DefaultValueAnnotationFactory(), new SemanticTermsTypeAnnotationFactory()).collect(Collectors.toMap(TypeAnnotationFactory::getKey, Function.identity()));
    }

    public MetadataType toMuleTypeWithAnnotations(WeaveType inputType) {
        Map scalaMimeTypeProperties = JavaConverters.mapAsScalaMap(java.util.Map.of()).toMap(Predef.conforms());
        return this.metadataModelConverter.toMuleType(inputType, MetadataFormat.JAVA, Option.empty(), scalaMimeTypeProperties);
    }

    public static MetadataType toMapMuleType() {
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
        return typeBuilder.objectType().openWith((TypeBuilder)typeBuilder.stringType()).build();
    }
}

