/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.model;

import com.mulesoft.connectivity.linkweave.api.model.ConnectorModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectionProviderModel;
import java.io.Serializable;
import java.util.List;
import org.jspecify.annotations.NullUnmarked;
import org.mule.runtime.api.meta.Category;

@NullUnmarked
public class MuleConnectorModel
extends ConnectorModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String version;
    private final String description;
    private final String vendor;
    private final Category category;
    private final List<MuleConnectionProviderModel> connectionProviderModelList;
    private final TestConnectionModel testConnectionModel;
    private final List<OperationModel> operations;
    private final List<TriggerModel> triggers;
    private final List<ValueProviderModel> valueProviders;

    private MuleConnectorModel(String name, String displayName, String version, String description, String vendor, Category category, List<MuleConnectionProviderModel> connectionProviderModelList, TestConnectionModel testConnectionModel, List<OperationModel> operations, List<TriggerModel> triggers, List<ValueProviderModel> valueProviders, String modelReference) {
        super(modelReference, name, displayName);
        this.version = version;
        this.description = description;
        this.vendor = vendor;
        this.category = category;
        this.connectionProviderModelList = connectionProviderModelList;
        this.testConnectionModel = testConnectionModel;
        this.operations = operations;
        this.triggers = triggers;
        this.valueProviders = valueProviders;
    }

    public String getVersion() {
        return this.version;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVendor() {
        return this.vendor;
    }

    public List<MuleConnectionProviderModel> getConnections() {
        return List.copyOf(this.connectionProviderModelList);
    }

    public TestConnectionModel getTestConnection() {
        return this.testConnectionModel;
    }

    public List<ValueProviderModel> getValueProviders() {
        return this.valueProviders;
    }

    public ValueProviderModel getValueProvider(String valueProviderReference) {
        return this.getValueProviders().stream().filter(provider -> provider.getName().equals(valueProviderReference)).findFirst().orElseThrow(() -> new IllegalStateException("Value provider not found: " + valueProviderReference));
    }

    public List<OperationModel> getOperations() {
        return this.operations;
    }

    public List<TriggerModel> getTriggers() {
        return this.triggers;
    }

    public String toString() {
        return "MuleConnectorModel{name='" + this.getName() + "'displayName='" + this.getDisplayName() + "'version='" + this.version + "'description='" + this.description + "'vendor='" + this.vendor + "'modelReference='" + this.modelReference + "'category=" + String.valueOf(this.category) + "'connections='" + String.valueOf(this.connectionProviderModelList) + "'testConnection='" + String.valueOf(this.testConnectionModel) + "'operations='" + String.valueOf(this.operations) + "'triggers='" + String.valueOf(this.triggers) + "'}";
    }

    public static class Builder
    extends ConnectorModel.Builder<MuleConnectorModel, Builder> {
        private String version;
        private String description;
        private String vendor;
        private Category category;
        private List<MuleConnectionProviderModel> connectionProviderModelList = List.of();
        private TestConnectionModel testConnectionModel;
        private List<OperationModel> operations = List.of();
        private List<TriggerModel> triggers = List.of();
        private List<ValueProviderModel> valueProviders = List.of();

        protected MuleConnectorModel createInstance() {
            this.validate();
            return new MuleConnectorModel(this.name, this.displayName, this.version, this.description, this.vendor, this.category, this.connectionProviderModelList, this.testConnectionModel, this.operations, this.triggers, this.valueProviders, this.modelReference);
        }

        protected Builder getThis() {
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withCategory(Category category) {
            this.category = category;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder withConnections(List<MuleConnectionProviderModel> connectionProviderModelList) {
            this.connectionProviderModelList = connectionProviderModelList;
            return this;
        }

        public Builder withTestConnection(TestConnectionModel testConnectionModel) {
            this.testConnectionModel = testConnectionModel;
            return this;
        }

        public Builder withOperations(List<OperationModel> operations) {
            this.operations = operations;
            return this;
        }

        public Builder withTriggers(List<TriggerModel> triggers) {
            this.triggers = triggers;
            return this;
        }

        public Builder withValueProviders(List<ValueProviderModel> valueProviders) {
            this.valueProviders = valueProviders;
            return this;
        }

        private void validate() throws IllegalStateException {
            StringBuilder messages = new StringBuilder();
            if (this.name == null || this.name.isBlank()) {
                messages.append("Name is required").append("\n");
            }
            if (this.displayName == null || this.displayName.isBlank()) {
                messages.append("DisplayName is required").append("\n");
            }
            if (this.version == null || this.version.isBlank()) {
                messages.append("Version is required").append("\n");
            }
            if (this.description == null || this.description.isBlank()) {
                messages.append("Description is required").append("\n");
            }
            if (this.vendor == null || this.vendor.isBlank()) {
                messages.append("Vendor is required").append("\n");
            }
            if (this.category == null) {
                messages.append("Category is required").append("\n");
            }
            if (this.modelReference == null || this.modelReference.isBlank()) {
                messages.append("ModelReference is required").append("\n");
            }
            if (this.isEmptyOrNull(this.connectionProviderModelList)) {
                messages.append("At least one Connection is required").append("\n");
            }
            if (this.testConnectionModel == null) {
                messages.append("TestConnection is required").append("\n");
            }
            this.validateOperationsAndTriggers(messages);
            if (!messages.isEmpty()) {
                throw new IllegalStateException(messages.toString());
            }
        }

        private boolean isEmptyOrNull(List<?> list) {
            return list == null || list.isEmpty();
        }

        private void validateOperationsAndTriggers(StringBuilder messages) {
            if (this.isEmptyOrNull(this.operations) && this.isEmptyOrNull(this.triggers)) {
                messages.append("At least one Operation or Trigger is required").append("\n");
            }
        }
    }
}

