/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.metadata;

import com.mulesoft.connectivity.mule.internal.metadata.DefaultValueAnnotationFactory;
import com.mulesoft.connectivity.mule.internal.metadata.TypeAnnotationFactoryTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.weave.v2.ts.LiteralMetadataValue;
import org.mule.weave.v2.ts.MetadataValue;
import org.mule.weave.v2.ts.StringType;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;

public class DefaultValueAnnotationFactoryTest
extends TypeAnnotationFactoryTest {
    @BeforeEach
    public void init() {
        this.typeAnnotationFactory = new DefaultValueAnnotationFactory();
    }

    @Test
    public void testDefaultValueAnnotationFactory() {
        String expectedValue = "A test default value description";
        LiteralMetadataValue metadataValue = new LiteralMetadataValue(expectedValue, (WeaveType)new StringType(Option.empty()), null);
        TypeAnnotation typeAnnotation = this.typeAnnotationFactory.create((MetadataValue)metadataValue);
        MatcherAssert.assertThat(typeAnnotation.getClass(), (Matcher)Matchers.is(DefaultValueAnnotation.class));
        MatcherAssert.assertThat((Object)typeAnnotation.getName(), (Matcher)Matchers.is((Object)"default"));
        this.assertAnnotationValue(typeAnnotation, expectedValue);
    }

    @Test
    public void testAnnotationWithNonStringLiteralType() {
        String expectedMessage = "The 'default value' metadata was supposed to be a string, but it's KeyValuePairMetadataValue instead.\n";
        this.assertAnnotationWithNonStringLiteralType(expectedMessage);
    }

    @Override
    protected void assertAnnotationValue(TypeAnnotation typeAnnotation, Object expectedValue) {
        MatcherAssert.assertThat((Object)((DefaultValueAnnotation)typeAnnotation).getValue(), (Matcher)Matchers.is((Object)expectedValue));
    }

    @Override
    protected String getAnnotationKey() {
        return "defaultValue";
    }
}

