/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.utils;

import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthCodeAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectionProviderModel;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectorModel;
import com.mulesoft.connectivity.mule.internal.utils.MuleConnectorModelTransformer;
import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleSourceSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleValueProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleTestConnectionSerializableModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.Category;
import org.mule.weave.v2.ts.StringType;
import scala.Option;

public class MuleConnectorModelTransformerTest {
    private static final String TEST_NAME = "test-connector";
    private static final String TEST_DISPLAY_NAME = "Test Connector";
    private static final String TEST_VERSION = "1.0.0";
    private static final String TEST_DESCRIPTION = "Test connector description";
    private static final String TEST_VENDOR = "Test Vendor";
    private static final String TEST_MODEL_REFERENCE = "testConnector::Connector";
    private static final String TEST_CONNECTION_REF = "testConnector::Connector::connector::testConnection";
    private static final String TEST_PROVIDER_REF = "testConnector::Connector::connector::connections::basicAuth";
    private static final String TEST_OPERATION_REF = "testConnector::Connector::operations::testOperation";
    private static final String TEST_TRIGGER_REF = "testConnector::Connector::triggers::testTrigger";
    private static final String TEST_TRIGGER_NAME = "testTrigger";
    private static final String TEST_TRIGGER_DISPLAY_NAME = "Test Trigger";
    private MuleConnectorModel muleConnectorModel;
    private MuleConnectionProviderModel connectionProvider;
    private TestConnectionModel testConnectionModel;
    private OperationModel muleOperationModel;
    private TriggerModel muleTriggerModel;
    private TypeModel mockTypeModel;
    private MuleConnectorModelTransformer muleConnectorModelTransformer;

    @BeforeEach
    public void setUp() {
        StringType stringType = new StringType(Option.empty());
        this.mockTypeModel = (TypeModel)Mockito.mock(TypeModel.class);
        Mockito.when((Object)this.mockTypeModel.getDataType()).thenReturn((Object)stringType);
        this.testConnectionModel = (TestConnectionModel)Mockito.mock(TestConnectionModel.class);
        Mockito.when((Object)this.testConnectionModel.getModelReference()).thenReturn(Optional.of(TEST_CONNECTION_REF));
        this.connectionProvider = this.createMuleConnectionProviderModel();
        this.muleOperationModel = this.createMuleOperationModel();
        this.muleTriggerModel = this.createMuleTriggerModel();
        this.muleConnectorModel = this.createMuleConnectorModel();
        this.muleConnectorModelTransformer = new MuleConnectorModelTransformer();
    }

    @Test
    public void shouldTransformCompleteConnectorModel() {
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(this.muleConnectorModel);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_NAME)));
        MatcherAssert.assertThat((Object)result.getDisplayName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_DISPLAY_NAME)));
        MatcherAssert.assertThat((Object)result.getVersion(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_VERSION)));
        MatcherAssert.assertThat((Object)result.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_DESCRIPTION)));
        MatcherAssert.assertThat((Object)result.getVendor(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_VENDOR)));
        MatcherAssert.assertThat((Object)result.getCategory(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Category.COMMUNITY)));
        MatcherAssert.assertThat((Object)result.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)result.getModelReference().get()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_MODEL_REFERENCE)));
        MatcherAssert.assertThat((Object)result.getConnections(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)result.getTestConnection(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.getOperations(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)result.getSources(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void shouldTransformSourceModel() {
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(this.muleConnectorModel);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.getSources(), (Matcher)Matchers.hasSize((int)1));
        MuleSourceSerializableModel source = (MuleSourceSerializableModel)result.getSources().get(0);
        MatcherAssert.assertThat((Object)source.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_TRIGGER_NAME)));
        MatcherAssert.assertThat((Object)source.getDisplayName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_TRIGGER_DISPLAY_NAME)));
        MatcherAssert.assertThat((Object)((String)source.getModelReference().get()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_TRIGGER_REF)));
        MatcherAssert.assertThat((Object)source.getInputType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)source.getOutputType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)source.getErrorOutputType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void shouldTransformConnectorModelWithMultipleConnectionProviders() {
        MuleConnectionProviderModel secondProvider = this.createMuleConnectionProviderModelWithApiKey();
        List<MuleConnectionProviderModel> providers = Arrays.asList(this.connectionProvider, secondProvider);
        MuleConnectorModel modelWithMultipleProviders = (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(Category.COMMUNITY).withConnections(providers).withTestConnection(this.testConnectionModel).withOperations(Collections.singletonList(this.muleOperationModel)).withModelReference(TEST_MODEL_REFERENCE)).build();
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelWithMultipleProviders);
        MatcherAssert.assertThat((Object)result.getConnections(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((MuleConnectionProviderSerializableModel)result.getConnections().get(0)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"basicAuth")));
        MatcherAssert.assertThat((Object)((MuleConnectionProviderSerializableModel)result.getConnections().get(1)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"apiKey")));
    }

    @Test
    public void shouldTransformTestConnectionModelWhenPresent() {
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(this.muleConnectorModel);
        MuleTestConnectionSerializableModel transformedTestConnection = result.getTestConnection();
        MatcherAssert.assertThat((Object)transformedTestConnection, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)transformedTestConnection.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)transformedTestConnection.getModelReference().get()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_CONNECTION_REF)));
    }

    @Test
    public void shouldTransformConnectionProviderWithBasicAuthentication() {
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(this.muleConnectorModel);
        MuleConnectionProviderSerializableModel transformedProvider = (MuleConnectionProviderSerializableModel)result.getConnections().get(0);
        MatcherAssert.assertThat((Object)transformedProvider, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)transformedProvider.getInputType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)transformedProvider.getAuthenticationType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)transformedProvider.getAuthenticationTypeName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"basic")));
        MatcherAssert.assertThat((Object)transformedProvider.hasExtensions(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)transformedProvider.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)transformedProvider.getModelReference().get()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_PROVIDER_REF)));
    }

    @Test
    public void shouldTransformConnectionProviderWithApiKeyAuthentication() {
        MuleConnectionProviderModel providerWithApiKey = this.createMuleConnectionProviderModelWithApiKey();
        MuleConnectorModel modelWithApiKey = (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(Category.COMMUNITY).withConnections(Collections.singletonList(providerWithApiKey)).withTestConnection(this.testConnectionModel).withModelReference(TEST_MODEL_REFERENCE)).withOperations(Collections.singletonList(this.muleOperationModel)).build();
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelWithApiKey);
        MuleConnectionProviderSerializableModel transformedProvider = (MuleConnectionProviderSerializableModel)result.getConnections().get(0);
        MatcherAssert.assertThat((Object)transformedProvider.getAuthenticationType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)transformedProvider.getAuthenticationTypeName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"apikey-custom-api-key")));
    }

    @Test
    public void shouldTransformConnectionProviderWithOAuth2AuthCodeAuthentication() {
        OAuth2AuthCodeAuthenticationType oAuth2AuthCode = new OAuth2AuthCodeAuthenticationType("https://refresh.url", Arrays.asList("read", "write"), "https://auth.url", "https://token.url");
        MuleConnectionProviderModel providerWithOAuth2 = this.createMuleConnectionProviderModelWithAuth((AuthenticationType)oAuth2AuthCode);
        MuleConnectorModel modelWithOAuth2 = (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(Category.COMMUNITY).withConnections(Collections.singletonList(providerWithOAuth2)).withTestConnection(this.testConnectionModel).withOperations(Collections.singletonList(this.muleOperationModel)).withModelReference(TEST_MODEL_REFERENCE)).build();
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelWithOAuth2);
        MuleConnectionProviderSerializableModel transformedProvider = (MuleConnectionProviderSerializableModel)result.getConnections().get(0);
        MatcherAssert.assertThat((Object)transformedProvider.getAuthenticationType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)transformedProvider.getAuthenticationTypeName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"oauth2-authorizationcode")));
    }

    @Test
    public void shouldTransformConnectionProviderWithOAuth2ClientCredentialsAuthentication() {
        OAuth2ClientCredentialsAuthenticationType oAuth2ClientCreds = new OAuth2ClientCredentialsAuthenticationType("https://refresh.url", Arrays.asList("read", "write"), "https://token.url");
        MuleConnectionProviderModel providerWithOAuth2 = this.createMuleConnectionProviderModelWithAuth((AuthenticationType)oAuth2ClientCreds);
        MuleConnectorModel modelWithOAuth2 = (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(Category.COMMUNITY).withConnections(Collections.singletonList(providerWithOAuth2)).withTestConnection(this.testConnectionModel).withOperations(Collections.singletonList(this.muleOperationModel)).withModelReference(TEST_MODEL_REFERENCE)).build();
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelWithOAuth2);
        MuleConnectionProviderSerializableModel transformedProvider = (MuleConnectionProviderSerializableModel)result.getConnections().get(0);
        MatcherAssert.assertThat((Object)transformedProvider.getAuthenticationType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)transformedProvider.getAuthenticationTypeName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"oauth2-clientcredentials")));
    }

    @Test
    public void shouldTransformConnectionProviderWithCustomAuthentication() {
        HttpAuthenticationType customAuth = new HttpAuthenticationType(HttpAuthenticationType.Type.custom, "my-custom-auth");
        MuleConnectionProviderModel providerWithCustomAuth = this.createMuleConnectionProviderModelWithAuth((AuthenticationType)customAuth);
        MuleConnectorModel modelWithCustomAuth = (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(Category.COMMUNITY).withConnections(Collections.singletonList(providerWithCustomAuth)).withTestConnection(this.testConnectionModel).withOperations(Collections.singletonList(this.muleOperationModel)).withModelReference(TEST_MODEL_REFERENCE)).build();
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelWithCustomAuth);
        MuleConnectionProviderSerializableModel transformedProvider = (MuleConnectionProviderSerializableModel)result.getConnections().get(0);
        MatcherAssert.assertThat((Object)transformedProvider.getAuthenticationType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)transformedProvider.getAuthenticationTypeName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"custom-my-custom-auth")));
    }

    @Test
    public void shouldTransformConnectionProviderWithoutTestConnection() {
        MuleConnectionProviderModel providerWithoutTestConnection = (MuleConnectionProviderModel)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)new MuleConnectionProviderModel.Builder().inputType(this.mockTypeModel)).authenticationType((AuthenticationType)new HttpAuthenticationType(HttpAuthenticationType.Type.basic, null))).hasExtensions(false)).withModelReference(TEST_PROVIDER_REF)).name("test")).build();
        MuleConnectorModel modelWithProviderWithoutTestConnection = (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(Category.COMMUNITY).withConnections(List.of(providerWithoutTestConnection)).withTestConnection(this.testConnectionModel).withModelReference(TEST_MODEL_REFERENCE)).withOperations(Collections.singletonList(this.muleOperationModel)).build();
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelWithProviderWithoutTestConnection);
        MuleConnectionProviderSerializableModel transformedProvider = (MuleConnectionProviderSerializableModel)result.getConnections().get(0);
        MatcherAssert.assertThat((Object)transformedProvider.getTestConnection(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldTransformAllCategoryTypes() {
        for (Category category : Category.values()) {
            MuleConnectorModel modelWithCategory = (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(category).withConnections(Collections.singletonList(this.connectionProvider)).withTestConnection(this.testConnectionModel).withOperations(Collections.singletonList(this.muleOperationModel)).withModelReference(TEST_MODEL_REFERENCE)).build();
            MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelWithCategory);
            MatcherAssert.assertThat((Object)result.getCategory(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)category)));
        }
    }

    @Test
    public void shouldReturnNullWhenTestConnectionModelIsNull() {
        Object nullTestConnection = null;
        MuleConnectorModel modelForNullTest = (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(Category.COMMUNITY).withConnections(Collections.singletonList(this.connectionProvider)).withTestConnection(this.testConnectionModel).withOperations(Collections.singletonList(this.muleOperationModel)).withModelReference(TEST_MODEL_REFERENCE)).build();
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelForNullTest);
        MatcherAssert.assertThat((Object)result.getTestConnection(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void shouldTransformAuthenticationTypeCorrectly() {
        HttpAuthenticationType basicAuth = new HttpAuthenticationType(HttpAuthenticationType.Type.basic, null);
        HttpAuthenticationType bearerAuth = new HttpAuthenticationType(HttpAuthenticationType.Type.bearer, "jwt");
        MuleConnectionProviderModel basicProvider = this.createMuleConnectionProviderModelWithAuth((AuthenticationType)basicAuth);
        MuleConnectorModel basicModel = this.createModelWithProvider(basicProvider);
        MuleConnectorSerializableModel basicResult = this.muleConnectorModelTransformer.toSerializableModel(basicModel);
        MatcherAssert.assertThat((Object)((MuleConnectionProviderSerializableModel)basicResult.getConnections().get(0)).getAuthenticationTypeName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"basic")));
        MuleConnectionProviderModel bearerProvider = this.createMuleConnectionProviderModelWithAuth((AuthenticationType)bearerAuth);
        MuleConnectorModel bearerModel = this.createModelWithProvider(bearerProvider);
        MuleConnectorSerializableModel bearerResult = this.muleConnectorModelTransformer.toSerializableModel(bearerModel);
        MatcherAssert.assertThat((Object)((MuleConnectionProviderSerializableModel)bearerResult.getConnections().get(0)).getAuthenticationTypeName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bearer-jwt")));
    }

    @Test
    public void shouldTransformConnectionProviderNameCorrectly() {
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(this.muleConnectorModel);
        MuleConnectionProviderSerializableModel transformedProvider = (MuleConnectionProviderSerializableModel)result.getConnections().get(0);
        MatcherAssert.assertThat((Object)transformedProvider.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"basicAuth")));
    }

    @Test
    public void shouldTransformMultipleConnectionProvidersWithDifferentNames() {
        MuleConnectionProviderModel basicProvider = (MuleConnectionProviderModel)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)new MuleConnectionProviderModel.Builder().inputType(this.mockTypeModel)).testConnection(this.testConnectionModel)).authenticationType((AuthenticationType)new HttpAuthenticationType(HttpAuthenticationType.Type.basic, null))).hasExtensions(true)).withModelReference(TEST_PROVIDER_REF)).name("basicAuth")).build();
        MuleConnectionProviderModel bearerProvider = (MuleConnectionProviderModel)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)new MuleConnectionProviderModel.Builder().inputType(this.mockTypeModel)).testConnection(this.testConnectionModel)).authenticationType((AuthenticationType)new HttpAuthenticationType(HttpAuthenticationType.Type.bearer, null))).hasExtensions(false)).withModelReference(TEST_PROVIDER_REF)).name("bearerAuth")).build();
        MuleConnectionProviderModel apiKeyProvider = (MuleConnectionProviderModel)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)new MuleConnectionProviderModel.Builder().inputType(this.mockTypeModel)).testConnection(this.testConnectionModel)).authenticationType((AuthenticationType)new ApiKeyHttpAuthenticationType("custom", ApiKeyHttpAuthenticationType.In.header, "X-API-Key"))).hasExtensions(true)).withModelReference(TEST_PROVIDER_REF)).name("apiKeyAuth")).build();
        List<MuleConnectionProviderModel> providers = Arrays.asList(basicProvider, bearerProvider, apiKeyProvider);
        MuleConnectorModel modelWithMultipleProviders = (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(Category.COMMUNITY).withConnections(providers).withTestConnection(this.testConnectionModel).withOperations(Collections.singletonList(this.muleOperationModel)).withModelReference(TEST_MODEL_REFERENCE)).build();
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelWithMultipleProviders);
        MatcherAssert.assertThat((Object)result.getConnections(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)((MuleConnectionProviderSerializableModel)result.getConnections().get(0)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"basicAuth")));
        MatcherAssert.assertThat((Object)((MuleConnectionProviderSerializableModel)result.getConnections().get(1)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bearerAuth")));
        MatcherAssert.assertThat((Object)((MuleConnectionProviderSerializableModel)result.getConnections().get(2)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"apiKeyAuth")));
    }

    private MuleConnectorModel createMuleConnectorModel() {
        return (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(Category.COMMUNITY).withConnections(Collections.singletonList(this.connectionProvider)).withTestConnection(this.testConnectionModel).withOperations(Collections.singletonList(this.muleOperationModel)).withTriggers(Collections.singletonList(this.muleTriggerModel)).withModelReference(TEST_MODEL_REFERENCE)).build();
    }

    private OperationModel createMuleOperationModel() {
        return (OperationModel)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)new OperationModel.Builder().withName("testOperation")).withDisplayName("Test Operation")).withInputType(this.mockTypeModel)).withOutputType(this.mockTypeModel)).withErrorOutputType(this.mockTypeModel)).isPaginated(true)).withModelReference(TEST_OPERATION_REF)).build();
    }

    private TriggerModel createMuleTriggerModel() {
        return (TriggerModel)((TriggerModel.Builder)((TriggerModel.Builder)((TriggerModel.Builder)((TriggerModel.Builder)((TriggerModel.Builder)((TriggerModel.Builder)((TriggerModel.Builder)((TriggerModel.Builder)TriggerModel.builder().withName(TEST_TRIGGER_NAME)).withDisplayName(TEST_TRIGGER_DISPLAY_NAME)).withInputType(this.mockTypeModel)).withOutputType(this.mockTypeModel)).withErrorOutputType(this.mockTypeModel)).isPaginated(false)).withModelReference(TEST_TRIGGER_REF)).withOrder("ASC")).build();
    }

    private MuleConnectionProviderModel createMuleConnectionProviderModel() {
        return (MuleConnectionProviderModel)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)new MuleConnectionProviderModel.Builder().inputType(this.mockTypeModel)).testConnection(this.testConnectionModel)).authenticationType((AuthenticationType)new HttpAuthenticationType(HttpAuthenticationType.Type.basic, null))).hasExtensions(true)).withModelReference(TEST_PROVIDER_REF)).name("basicAuth")).build();
    }

    private MuleConnectionProviderModel createMuleConnectionProviderModelWithApiKey() {
        ApiKeyHttpAuthenticationType apiKeyAuth = new ApiKeyHttpAuthenticationType("custom-api-key", ApiKeyHttpAuthenticationType.In.header, "X-API-Key");
        return (MuleConnectionProviderModel)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)new MuleConnectionProviderModel.Builder().inputType(this.mockTypeModel)).testConnection(this.testConnectionModel)).authenticationType((AuthenticationType)apiKeyAuth)).hasExtensions(false)).withModelReference(TEST_PROVIDER_REF)).name("apiKey")).build();
    }

    private MuleConnectionProviderModel createMuleConnectionProviderModelWithAuth(AuthenticationType authType) {
        return (MuleConnectionProviderModel)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)new MuleConnectionProviderModel.Builder().inputType(this.mockTypeModel)).testConnection(this.testConnectionModel)).authenticationType(authType)).hasExtensions(true)).withModelReference(TEST_PROVIDER_REF)).name("auth")).build();
    }

    private MuleConnectorModel createModelWithProvider(MuleConnectionProviderModel provider) {
        return (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(Category.COMMUNITY).withConnections(Collections.singletonList(provider)).withTestConnection(this.testConnectionModel).withOperations(Collections.singletonList(this.muleOperationModel)).withModelReference(TEST_MODEL_REFERENCE)).build();
    }

    @Test
    public void shouldTransformConnectorModelWithMultipleValueProviders() {
        ValueProviderModel valueProvider1 = this.createValueProviderModel("valueProvider1", "valueProvider1::ValueProvider");
        ValueProviderModel valueProvider2 = this.createValueProviderModel("valueProvider2", "valueProvider2::ValueProvider", true);
        MuleConnectorModel modelWithMultipleValueProviders = this.createModelWithValueProviders(Arrays.asList(valueProvider1, valueProvider2));
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelWithMultipleValueProviders);
        MatcherAssert.assertThat((Object)result.getValueProviders(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((MuleValueProviderSerializableModel)result.getValueProviders().get(0)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"valueProvider1")));
        MatcherAssert.assertThat((Object)((MuleValueProviderSerializableModel)result.getValueProviders().get(0)).isPaginated(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((MuleValueProviderSerializableModel)result.getValueProviders().get(1)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"valueProvider2")));
        MatcherAssert.assertThat((Object)((MuleValueProviderSerializableModel)result.getValueProviders().get(1)).isPaginated(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldTransformConnectorModelWithPaginatedValueProvider() {
        ValueProviderModel paginatedValueProvider = this.createValueProviderModel("paginatedProvider", "paginatedProvider::ValueProvider", true);
        MuleConnectorModel modelWithPaginatedValueProvider = this.createModelWithValueProviders(Collections.singletonList(paginatedValueProvider));
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelWithPaginatedValueProvider);
        MatcherAssert.assertThat((Object)result.getValueProviders(), (Matcher)Matchers.hasSize((int)1));
        MuleValueProviderSerializableModel transformedValueProvider = (MuleValueProviderSerializableModel)result.getValueProviders().get(0);
        MatcherAssert.assertThat((Object)transformedValueProvider.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"paginatedProvider")));
        MatcherAssert.assertThat((Object)transformedValueProvider.isPaginated(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldTransformConnectorModelWithEmptyValueProviders() {
        MuleConnectorModel modelWithEmptyValueProviders = this.createModelWithValueProviders(Collections.emptyList());
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(modelWithEmptyValueProviders);
        MatcherAssert.assertThat((Object)result.getValueProviders(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)result.getValueProviders().isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldTransformCompleteConnectorModelWithAllComponents() {
        ValueProviderModel valueProvider = this.createValueProviderModel();
        MuleConnectorModel completeModel = this.createModelWithValueProviders(Collections.singletonList(valueProvider));
        MuleConnectorSerializableModel result = this.muleConnectorModelTransformer.toSerializableModel(completeModel);
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_NAME)));
        MatcherAssert.assertThat((Object)result.getDisplayName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_DISPLAY_NAME)));
        MatcherAssert.assertThat((Object)result.getVersion(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_VERSION)));
        MatcherAssert.assertThat((Object)result.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_DESCRIPTION)));
        MatcherAssert.assertThat((Object)result.getVendor(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_VENDOR)));
        MatcherAssert.assertThat((Object)result.getCategory(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Category.COMMUNITY)));
        MatcherAssert.assertThat((Object)result.getModelReference().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)result.getModelReference().get()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_MODEL_REFERENCE)));
        MatcherAssert.assertThat((Object)result.getConnections(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)result.getTestConnection(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.getOperations(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)result.getValueProviders(), (Matcher)Matchers.hasSize((int)1));
    }

    private ValueProviderModel createValueProviderModel() {
        return this.createValueProviderModel("testValueProvider", "testValueProvider::ValueProvider", false);
    }

    private ValueProviderModel createValueProviderModel(String name, String modelReference) {
        return this.createValueProviderModel(name, modelReference, false);
    }

    private ValueProviderModel createValueProviderModel(String name, String modelReference, boolean isPaginated) {
        return (ValueProviderModel)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)new ValueProviderModel.Builder().name(name)).inputType(this.mockTypeModel)).providedValueType(this.mockTypeModel)).errorOutputType(this.mockTypeModel)).displayPropertiesType(this.mockTypeModel)).isPaginated(isPaginated)).withModelReference(modelReference)).build();
    }

    private MuleConnectorModel createModelWithValueProviders(List<ValueProviderModel> valueProviderModels) {
        return (MuleConnectorModel)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName(TEST_NAME)).withDisplayName(TEST_DISPLAY_NAME)).withVersion(TEST_VERSION).withDescription(TEST_DESCRIPTION).withVendor(TEST_VENDOR).withCategory(Category.COMMUNITY).withConnections(Collections.singletonList(this.connectionProvider)).withTestConnection(this.testConnectionModel).withOperations(Collections.singletonList(this.muleOperationModel)).withValueProviders(valueProviderModels).withModelReference(TEST_MODEL_REFERENCE)).build();
    }
}

