/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.metadata;

import com.mulesoft.connectivity.linkweave.api.loader.InvalidConnectorException;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;
import com.mulesoft.connectivity.mule.internal.metadata.TypeAnnotationFactory;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.SemanticTermsTypeAnnotation;
import org.mule.weave.v2.api.tooling.ts.ArrayMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWMetadataValue;
import org.mule.weave.v2.ts.MetadataValue;

public class SemanticTermsTypeAnnotationFactory
implements TypeAnnotationFactory {
    public static final String SEMANTIC_TERMS_ANNOTATION_KEY = "semanticTerms";
    public static final String ANNOTATION_DESCRIPTION = "The 'semanticTerms' metadata";

    @Override
    public String getKey() {
        return SEMANTIC_TERMS_ANNOTATION_KEY;
    }

    @Override
    public TypeAnnotation create(MetadataValue metadataValue) {
        return new SemanticTermsTypeAnnotation(SemanticTermsTypeAnnotationFactory.asSet((DWMetadataValue)metadataValue, ANNOTATION_DESCRIPTION));
    }

    public static Set<String> asSet(DWMetadataValue metadataValue, String what) {
        if (!(metadataValue instanceof ArrayMetadataValue)) {
            throw new InvalidConnectorException(what + " was supposed to be an array, but it's " + MetadataValueUtils.describeType((DWMetadataValue)metadataValue) + " instead.", metadataValue.getLocation());
        }
        return Stream.of(((ArrayMetadataValue)metadataValue).getElements()).map(mv -> MetadataValueUtils.asString((DWMetadataValue)mv, (String)(what + " element"))).collect(Collectors.toCollection(TreeSet::new));
    }
}

