/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.metadata;

import com.mulesoft.connectivity.mule.internal.metadata.DescriptionTypeAnnotationFactory;
import com.mulesoft.connectivity.mule.internal.metadata.TypeAnnotationFactoryTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.weave.v2.ts.LiteralMetadataValue;
import org.mule.weave.v2.ts.MetadataValue;
import org.mule.weave.v2.ts.StringType;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;

public class DescriptionTypeAnnotationFactoryTest
extends TypeAnnotationFactoryTest {
    @BeforeEach
    public void init() {
        this.typeAnnotationFactory = new DescriptionTypeAnnotationFactory();
    }

    @Test
    public void testDescriptionAnnotationFactory() {
        String expectedValue = "A test description";
        LiteralMetadataValue metadataValue = new LiteralMetadataValue(expectedValue, (WeaveType)new StringType(Option.empty()), null);
        this.assertAnnotationFactory((MetadataValue)metadataValue, expectedValue, DescriptionAnnotation.class);
    }

    @Test
    public void testAnnotationWithNonStringLiteralType() {
        String expectedMessage = "The 'description' metadata was supposed to be a string, but it's KeyValuePairMetadataValue instead.\n";
        this.assertAnnotationWithNonStringLiteralType(expectedMessage);
    }

    @Override
    protected void assertAnnotationValue(TypeAnnotation typeAnnotation, Object expectedValue) {
        MatcherAssert.assertThat((Object)((DescriptionAnnotation)typeAnnotation).getValue(), (Matcher)Matchers.is((Object)expectedValue));
    }

    @Override
    protected String getAnnotationKey() {
        return "description";
    }
}

