/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.metadata;

import com.mulesoft.connectivity.mule.internal.metadata.SemanticTermsTypeAnnotationFactory;
import com.mulesoft.connectivity.mule.internal.metadata.TypeAnnotationFactoryTest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.SemanticTermsTypeAnnotation;
import org.mule.weave.v2.ts.ArrayMetadataValue;
import org.mule.weave.v2.ts.LiteralMetadataValue;
import org.mule.weave.v2.ts.MetadataValue;
import org.mule.weave.v2.ts.StringType;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SemanticTermsTypeAnnotationFactoryTest
extends TypeAnnotationFactoryTest {
    @BeforeEach
    public void init() {
        this.typeAnnotationFactory = new SemanticTermsTypeAnnotationFactory();
    }

    @Test
    public void testSemanticTermsAnnotationFactory() {
        ArrayList<LiteralMetadataValue> metadataValues = new ArrayList<LiteralMetadataValue>();
        metadataValues.add(new LiteralMetadataValue("semanticTermV1", (WeaveType)new StringType(Option.empty()), null));
        metadataValues.add(new LiteralMetadataValue("semanticTermV2", (WeaveType)new StringType(Option.empty()), null));
        ArrayMetadataValue metadataValue = new ArrayMetadataValue((Seq)JavaConverters.asScalaBuffer(metadataValues).seq(), null);
        HashSet<String> semanticValues = new HashSet<String>();
        semanticValues.add("semanticTermV1");
        semanticValues.add("semanticTermV2");
        this.assertAnnotationFactory((MetadataValue)metadataValue, semanticValues, SemanticTermsTypeAnnotation.class);
    }

    @Test
    public void testAnnotationWithNonStringLiteralType() {
        String expectedMessage = "The 'semanticTerms' metadata was supposed to be an array, but it's KeyValuePairMetadataValue instead.\n";
        this.assertAnnotationWithNonStringLiteralType(expectedMessage);
    }

    @Override
    protected String getAnnotationKey() {
        return "semanticTerms";
    }

    @Override
    protected void assertAnnotationValue(TypeAnnotation typeAnnotation, Object expectedValue) {
        MatcherAssert.assertThat((Object)expectedValue, (Matcher)Matchers.instanceOf(Set.class));
        MatcherAssert.assertThat((Object)((SemanticTermsTypeAnnotation)typeAnnotation).getSemanticTerms(), (Matcher)Matchers.is((Object)expectedValue));
    }
}

