/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.internal.model;

import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.AuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectionProviderModel;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectorModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mule.runtime.api.meta.Category;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.ts.NullType;

class MuleConnectorModelTest {
    private static final DWType nullWeaveType = new NullType();
    private static final TypeModel nullTypeModel = (TypeModel)new TypeModel.Builder().withDataType(nullWeaveType).build();
    private final MuleConnectionProviderModel connectionModel = (MuleConnectionProviderModel)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)((MuleConnectionProviderModel.Builder)new MuleConnectionProviderModel.Builder().inputType(nullTypeModel)).name("connection")).authenticationType((AuthenticationType)new HttpAuthenticationType(HttpAuthenticationType.Type.basic, null))).withModelReference("com::mulesoft::connectivity::pulse::Connector")).build();
    private final OperationModel operationModel = (OperationModel)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)((OperationModel.Builder)new OperationModel.Builder().withName("TestOperation")).withDisplayName("Test Operation")).withInputType(nullTypeModel)).withOutputType(nullTypeModel)).withErrorOutputType(nullTypeModel)).build();
    private final TriggerModel triggerModel = (TriggerModel)((TriggerModel.Builder)((TriggerModel.Builder)((TriggerModel.Builder)((TriggerModel.Builder)((TriggerModel.Builder)((TriggerModel.Builder)new TriggerModel.Builder().withName("TestTrigger")).withDisplayName("Test Trigger")).withInputType(nullTypeModel)).withOutputType(nullTypeModel)).withOrder("ASC")).withErrorOutputType(nullTypeModel)).build();
    private final ValueProviderModel valueProviderModel = (ValueProviderModel)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)new ValueProviderModel.Builder().name("testValueProvider")).inputType(nullTypeModel)).providedValueType(nullTypeModel)).displayPropertiesType(nullTypeModel)).errorOutputType(nullTypeModel)).isPaginated(false)).build();

    MuleConnectorModelTest() {
    }

    private MuleConnectorModel.Builder getMuleConnectorModelBuilder() {
        return ((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)((MuleConnectorModel.Builder)new MuleConnectorModel.Builder().withName("PULSE")).withModelReference("com::mulesoft::connectivity::pulse::Connector")).withVersion("1.0.0").withDisplayName("Pulse CONNECTOR")).withDescription("Pulse Connector to test the IC Mule Extension").withVendor("Salesforce").withCategory(Category.COMMUNITY).withConnections(Collections.singletonList(this.connectionModel)).withTestConnection((TestConnectionModel)new TestConnectionModel.Builder().build()).withOperations(Collections.singletonList(this.operationModel));
    }

    private MuleConnectorModel getMuleConnectorModel() {
        return (MuleConnectorModel)this.getMuleConnectorModelBuilder().build();
    }

    private MuleConnectorModel getMuleConnectorModelWithValueProviders(List<ValueProviderModel> valueProviders) {
        return (MuleConnectorModel)this.getMuleConnectorModelBuilder().withValueProviders(valueProviders).build();
    }

    void apply(MuleConnectorModel.Builder builder, String what) {
        switch (what) {
            case "name": {
                builder.withName("PULSE");
                break;
            }
            case "modelReference": {
                builder.withModelReference("com::mulesoft::connectivity::pulse::Connector");
                break;
            }
            case "version": {
                builder.withVersion("1.0.0");
                break;
            }
            case "displayName": {
                builder.withDisplayName("Pulse CONNECTOR");
                break;
            }
            case "description": {
                builder.withDescription("Pulse Connector to test the IC Mule Extension");
                break;
            }
            case "vendor": {
                builder.withVendor("Salesforce");
                break;
            }
            case "category": {
                builder.withCategory(Category.COMMUNITY);
                break;
            }
            case "connections": {
                builder.withConnections(Collections.singletonList(this.connectionModel));
                break;
            }
            case "testConnection": {
                builder.withTestConnection((TestConnectionModel)new TestConnectionModel.Builder().build());
                break;
            }
            case "operations": {
                builder.withOperations(Collections.singletonList(this.operationModel));
                break;
            }
            case "triggers": {
                builder.withTriggers(Collections.singletonList(this.triggerModel));
            }
        }
    }

    static Stream<String> fieldProvider() {
        return Stream.of("name", "modelReference", "version", "displayName", "description", "category", "vendor", "connections", "testConnection", "operations", "triggers");
    }

    @ParameterizedTest
    @MethodSource(value={"fieldProvider"})
    void validateWithout(String except) {
        MuleConnectorModel.Builder builder = new MuleConnectorModel.Builder();
        Set<String> fieldsToSkip = except.equals("operations") || except.equals("triggers") ? Set.of("operations", "triggers") : Set.of(except);
        for (String field : MuleConnectorModelTest.fieldProvider().collect(Collectors.toSet())) {
            if (fieldsToSkip.contains(field)) continue;
            this.apply(builder, field);
        }
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((MuleConnectorModel.Builder)builder).build());
        String expectedMessage = this.getExpectedMessage(except);
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)(expectedMessage + "\n")));
    }

    private String getExpectedMessage(String field) {
        switch (field) {
            case "name": {
                return "Name is required";
            }
            case "modelReference": {
                return "ModelReference is required";
            }
            case "version": {
                return "Version is required";
            }
            case "displayName": {
                return "DisplayName is required";
            }
            case "description": {
                return "Description is required";
            }
            case "vendor": {
                return "Vendor is required";
            }
            case "category": {
                return "Category is required";
            }
            case "connections": {
                return "At least one Connection is required";
            }
            case "testConnection": {
                return "TestConnection is required";
            }
            case "operations": 
            case "triggers": {
                return "At least one Operation or Trigger is required";
            }
        }
        throw new IllegalArgumentException("Unexpected field: " + field);
    }

    @Test
    void getValueProviderByName() {
        MuleConnectorModel connector = this.getMuleConnectorModelWithValueProviders(Collections.singletonList(this.valueProviderModel));
        ValueProviderModel found = connector.getValueProvider("testValueProvider");
        MatcherAssert.assertThat((Object)found, (Matcher)Matchers.is((Object)this.valueProviderModel));
        MatcherAssert.assertThat((Object)found.getName(), (Matcher)Matchers.is((Object)"testValueProvider"));
    }

    @Test
    void getValueProviderByNameThrowsExceptionWhenNotFound() {
        MuleConnectorModel connector = this.getMuleConnectorModelWithValueProviders(Collections.singletonList(this.valueProviderModel));
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> connector.getValueProvider("nonExistentProvider"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"Value provider not found: nonExistentProvider"));
    }

    @Test
    void buildConnectorWithEmptyValueProvidersList() {
        MuleConnectorModel connector = this.getMuleConnectorModelWithValueProviders(Collections.emptyList());
        MatcherAssert.assertThat((Object)connector.getValueProviders(), (Matcher)Matchers.is(Collections.emptyList()));
        MatcherAssert.assertThat((Object)connector.getValueProviders().isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void valueProviderPropertiesAreCorrectlySet() {
        ValueProviderModel customValueProvider = (ValueProviderModel)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)((ValueProviderModel.Builder)new ValueProviderModel.Builder().name("customProvider")).inputType(nullTypeModel)).providedValueType(nullTypeModel)).errorOutputType(nullTypeModel)).displayPropertiesType(nullTypeModel)).isPaginated(true)).build();
        MuleConnectorModel connector = this.getMuleConnectorModelWithValueProviders(Collections.singletonList(customValueProvider));
        ValueProviderModel found = connector.getValueProvider("customProvider");
        MatcherAssert.assertThat((Object)found.getName(), (Matcher)Matchers.is((Object)"customProvider"));
        MatcherAssert.assertThat((Object)found.isPaginated(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)found.getInputType(), (Matcher)Matchers.is((Object)nullTypeModel));
        MatcherAssert.assertThat((Object)found.getProvidedValueType(), (Matcher)Matchers.is((Object)nullTypeModel));
        MatcherAssert.assertThat((Object)found.getErrorOutputType(), (Matcher)Matchers.is((Object)nullTypeModel));
    }
}

