/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.maven.mojo;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.connectivity.linkweave.api.model.CodeSourceLocation;
import com.mulesoft.connectivity.maven.api.model.Phase;
import com.mulesoft.connectivity.maven.api.model.Status;
import com.mulesoft.connectivity.mule.maven.mojo.AbstractMuleMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="packageConnector", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyCollection=ResolutionScope.RUNTIME, threadSafe=true)
public class MulePackagingMojo
extends AbstractMuleMojo {
    private static final String MIN_MULE_VERSION = "4.8.0";
    private static final String[] MULE_ARTIFACT_JSON_PATH = "classes/META-INF/mule-artifact/mule-artifact.json".split("/");

    public void execute() throws MojoExecutionException {
        try {
            String artifactName = this.project.getArtifactId();
            Map<String, Map<String, String>> extensionModelLoaderDescriptorJSON = Map.of("id", "interpreted-connectivity", "attributes", Map.of("modelReference", this.modelReferenceFor(this.dwRef)));
            Map classLoaderModelLoaderDescriptorJSON = Map.of("id", "mule", "attributes", Map.of());
            Map bundleDescriptorLoaderJSON = Map.of("id", "mule", "attributes", Map.of());
            Map muleArtifactJSON = Map.of("name", artifactName, "minMuleVersion", MIN_MULE_VERSION, "requiredProduct", "MULE", "extensionModelLoaderDescriptor", extensionModelLoaderDescriptorJSON, "classLoaderModelLoaderDescriptor", classLoaderModelLoaderDescriptorJSON, "bundleDescriptorLoader", bundleDescriptorLoaderJSON);
            this.writeMuleArtifactJSON(muleArtifactJSON);
            this.writeMojoResult(Phase.PACKAGE, Status.SUCCESS);
        }
        catch (Exception ex) {
            this.writeMojoResult(Phase.PACKAGE, Status.FAILURE, ex, Collections.emptyMap());
            throw new MojoExecutionException("Failed to create the `mule-artifact.json` descriptor: " + ex.getMessage(), ex);
        }
    }

    private String modelReferenceFor(String connectorReference) {
        CodeSourceLocation location = Objects.requireNonNull(CodeSourceLocation.from((String)connectorReference));
        return String.join((CharSequence)"::", location.getModuleParts());
    }

    private void writeMuleArtifactJSON(Map<String, ?> contents) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonText = gson.toJson(contents);
        Path muleArtifactJSONPath = Path.of(this.project.getBuild().getDirectory(), MULE_ARTIFACT_JSON_PATH);
        File outputFile = muleArtifactJSONPath.toFile();
        File outputFolder = outputFile.getParentFile();
        if (!outputFolder.exists() && !outputFolder.mkdirs()) {
            throw new IllegalStateException("Failed to create " + outputFolder.getPath());
        }
        try (FileOutputStream output = new FileOutputStream(outputFile);){
            output.write(jsonText.getBytes(StandardCharsets.UTF_8));
        }
    }
}

