%dw 2.7

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Annotations
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::mule::Metadata
import * from com::mulesoft::connectivity::transport::Http

// ------ Types Definition ------
// ----------------
//  - Auth Types -
// ----------------

type AuthConnection = @Label(value = "Basic connection") {
    orgId: @Label(value = "orgId basic connection") String,
    token: @Label(value = "token basic connection") String
}

// ----------------------------
//  - Basic Types -
// ----------------------------

type RestApiError = {
    errorCode?: String,
    message?: String
}

type ErrorInfo = {
    message?: String,
    errorCode?: String,
    fields?: Array<String>,
    extendedErrorDetails?: Array<{ extendedErrorCode?: String }>
}

type GenericError = Array<ErrorInfo> | Array<RestApiError>

// -----------------------------
//  - Record Types -
// -----------------------------

type AccountSObject = {
    id: String,
    name?: String
}

// --------------------------------
//  - Operation Types -
// --------------------------------
type AccountGetOperation = {
    response200: AccountSObject,
    request: HttpRequestType<{|
        uri: {| id: String |},
        query?: {
            fields?: String
        },
        headers?: {
        },
        cookie?: Object
    |}>,
    response: AccountSObject
}

// ------ Module Definition ------
var BASE_URL = 'https://{orgId}.test.com/services/data/v60.0'

@ConnectionElement()
var bearerConnection = defineBearerHttpConnectionProvider<AuthConnection>(
    (parameter) -> { token: parameter.token },
    (parameter) -> {
        baseUri: BASE_URL replace "{orgId}" with parameter.orgId
    }
)

var getAccountMetadataForTestConnection : Operation<{}, Any, ResultFailure<Any, Error>, HttpConnection> = {
    name: "getAccountMetadataForTestConnection",
    displayName: "Get Account Metadata For TestConnection",
    executor: (parameter, connection) -> do {
        var response = connection({
            method: 'GET',
            path: '/sobjects/Account/describe'
        })
        ---
        if (response.status == 200)
            success(response)
        else
            failure(response)
    }
}

@TestConnectionElement()
var testConnection : HttpTestConnection = {
    validate: defineTestConnection(
        getAccountMetadataForTestConnection,
        (response) -> {
            isValid: response.success,
            message: if (response.success) "Connection test succeeded" else "Connection test failed"
        }
    )
}

var operations = {
    "/Account/{id}": {
        get: {
            name: "getAccountById",
            displayName: "Get Account By Id",
            executor: (parameter, connection) -> do {
                var response = connection({
                    method: "GET",
                    path: "/sobjects/Account/" ++ parameter.uri.id,
                    queryParams: parameter.query default {},
                    headers: parameter.headers default {},
                    cookie: parameter.cookie default {},
                })
                ---
                if (response.status == 200)
                    success(response)
                else
                    failure(response)
            }
        } as HttpOperation<
            AccountGetOperation.request,
            AccountGetOperation.response,
            GenericError,
            HttpConnection
        >
    },
}

// ------ Connector Definition ------
@MuleConnectorElement()
var invalidConnector = {
    name: "TEST",
    displayName: "Test",
    version: "0.1.0",
    releaseStatus: "PILOT",
    description: "Test Connector",
    vendor: "Salesforce",
    category: "community",
    icons: [
        {
            name: "Test",
            alternateText: "Test Connector",
            resource: "icon/test.svg",
            size: 13040,
            dimensions: "256x180"
        }
    ],
    connections: {
      bearerConnection: bearerConnection
    },
    testConnection: testConnection,
    operations: {
        getAccount: operations."/Account/{id}".get,
        getAccount: operations."/Account/{id}".get
    },
    valueProviders: {},
    metadataProviders: {}
}
