/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.maven.mojo;

import com.mulesoft.connectivity.maven.api.model.Phase;
import com.mulesoft.connectivity.maven.api.model.Status;
import com.mulesoft.connectivity.mule.internal.loader.MuleModelLoader;
import com.mulesoft.connectivity.mule.maven.mojo.AbstractMuleMojo;
import com.mulesoft.connectivity.mule.validator.MuleValidationConfiguration;
import com.mulesoft.connectivity.validation.ConnectorValidationAnnotationProcessor;
import com.mulesoft.connectivity.validation.ValidationConfiguration;
import java.util.Collections;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ParserConfiguration;

@Mojo(name="validateConnectorModel", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
public class MuleValidationMojo
extends AbstractMuleMojo {
    @Parameter(property="skipMuleModelValidation")
    private boolean skipMuleModelValidation;

    public boolean isSkipMuleModelValidation() {
        return this.skipMuleModelValidation;
    }

    public void setSkipMuleModelValidation(boolean skipMuleModelValidation) {
        this.skipMuleModelValidation = skipMuleModelValidation;
    }

    public void execute() throws MojoExecutionException {
        if (this.skipMuleModelValidation) {
            return;
        }
        try {
            MuleValidationMojo.withContextClassLoader((ClassLoader)this.getCustomClassLoader(), () -> {
                ParserConfiguration parserConfiguration = ConnectorValidationAnnotationProcessor.getParserConfigurationForValidation((NameIdentifier)MULE_CONNECTOR_ELEMENT, (ValidationConfiguration)new MuleValidationConfiguration());
                DataWeaveScriptingEngine dataWeaveEngine = this.getDwEngine(parserConfiguration);
                MuleModelLoader muleLoader = new MuleModelLoader(dataWeaveEngine);
                muleLoader.loadConnector(this.dwRef);
                this.writeMojoResult(Phase.VALIDATE, Status.SUCCESS);
                return null;
            });
        }
        catch (Exception ex) {
            this.writeMojoResult(Phase.PACKAGE, Status.FAILURE, ex, Collections.emptyMap());
            throw new MojoExecutionException("Failed to create the Mule Connector Static Model: " + ex.getMessage(), ex);
        }
    }
}

