/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.maven.mojo;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.model.CodeSourceLocation;
import com.mulesoft.connectivity.maven.api.model.Phase;
import com.mulesoft.connectivity.maven.api.model.Status;
import com.mulesoft.connectivity.mule.internal.loader.MuleConnectorLoaderFactory;
import com.mulesoft.connectivity.mule.internal.model.MuleConnectorModel;
import com.mulesoft.connectivity.mule.internal.persistence.MuleModelSerializer;
import com.mulesoft.connectivity.mule.maven.mojo.AbstractMuleMojo;
import com.mulesoft.connectivity.mule.maven.mojo.MuleArtifactTemplate;
import com.mulesoft.connectivity.mule.maven.mojo.MuleArtifactTemplatePopulator;
import com.mulesoft.connectivity.mule.persistence.deserialize.loader.MuleModelDeserializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ParserConfigurationBuilder;

@Mojo(name="createMuleStaticModel", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
public class MuleStaticModelMojo
extends AbstractMuleMojo {
    private static final String ICON_SVG = "icon.svg";
    private static final String GENERIC_CONNECTOR_SVG = "generic-connector.svg";
    private static final String ICON_FOLDER = File.separator + "icon" + File.separator;
    private static final String EXPECTED_ICON_RELATIVE_PATH = ICON_FOLDER + "icon.svg";
    private static final String MULE_ARTIFACT_FOLDER = "mule-artifact";
    @Parameter(property="directoryPath", defaultValue="${project.build.directory}/classes/META-INF")
    private String directoryPath;
    @Parameter(property="muleArtifactFile", defaultValue="mule-artifact/mule-artifact.json")
    private String muleArtifactFile;

    public void execute() throws MojoExecutionException {
        try {
            MuleStaticModelMojo.withContextClassLoader((ClassLoader)this.getCustomClassLoader(), () -> {
                DataWeaveScriptingEngine dataWeaveEngine = this.getDwEngine(new ParserConfigurationBuilder().build());
                LanguageModelLoader muleLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new MuleConnectorLoaderFactory().create(), MULE_CONNECTOR_ELEMENT);
                MuleConnectorModel connectorModel = (MuleConnectorModel)muleLoader.loadModule(this.modelReferenceFor(this.dwRef));
                MuleArtifactTemplate muleArtifactTemplate = MuleArtifactTemplatePopulator.populate(this.project, connectorModel);
                Map<String, Object> muleArtifactJSON = muleArtifactTemplate.toMap();
                this.writeSerializedModel(connectorModel);
                this.writeMuleArtifactJSON(muleArtifactJSON);
                this.addIcons();
                this.validateSerializedModel(connectorModel);
                this.writeMojoResult(Phase.PACKAGE, Status.SUCCESS);
                return null;
            });
        }
        catch (Exception ex) {
            this.writeMojoResult(Phase.PACKAGE, Status.FAILURE, ex, Collections.emptyMap());
            throw new MojoExecutionException("Failed to create the Mule Connector Static Model: " + ex.getMessage(), ex);
        }
    }

    private void addIcons() throws MojoExecutionException {
        block13: {
            File iconFile = new File(this.project.getBasedir(), EXPECTED_ICON_RELATIVE_PATH);
            Path muleArtifactPath = Path.of(this.directoryPath, new String[0]).resolve(MULE_ARTIFACT_FOLDER);
            if (!iconFile.exists()) {
                try (InputStream resource = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(GENERIC_CONNECTOR_SVG);){
                    File outputIconFile = muleArtifactPath.resolve(ICON_SVG).toFile();
                    try {
                        Files.copy(resource, Paths.get(outputIconFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        break block13;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException(String.format("There was an issue while copying the resource [%s]", GENERIC_CONNECTOR_SVG), (Exception)e);
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to access generic connector icon resource", (Exception)e);
                }
            }
            try {
                Path targetIconPath = muleArtifactPath.resolve(ICON_SVG);
                Files.copy(iconFile.toPath(), targetIconPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Failed to copy icon from [%s] to [%s]", iconFile.getAbsolutePath(), muleArtifactPath.resolve(ICON_SVG)), (Exception)e);
            }
        }
    }

    private String modelReferenceFor(String connectorReference) {
        CodeSourceLocation location = Objects.requireNonNull(CodeSourceLocation.from((String)connectorReference));
        return String.join((CharSequence)"::", location.getModuleParts());
    }

    private void writeMuleArtifactJSON(Map<String, ?> contents) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonText = gson.toJson(contents);
        Path muleArtifactJSONPath = Path.of(this.directoryPath, new String[0]).resolve(this.muleArtifactFile);
        try {
            Files.createDirectories(muleArtifactJSONPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create " + String.valueOf(muleArtifactJSONPath.getParent()));
        }
        try (FileOutputStream output = new FileOutputStream(muleArtifactJSONPath.toFile());){
            output.write(jsonText.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void writeSerializedModel(MuleConnectorModel connectorModel) throws MojoExecutionException {
        MuleModelSerializer muleModelSerializer = new MuleModelSerializer();
        String actualSerializedModel = muleModelSerializer.serialize(connectorModel);
        Path serializedModelPath = this.getMuleSerializedIcPath(connectorModel);
        try (Writer serializedModelWriter = this.getFileWriter(serializedModelPath);){
            serializedModelWriter.write(actualSerializedModel);
        }
        catch (IOException | MojoExecutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private Path getMuleSerializedIcPath(MuleConnectorModel connectorModel) {
        String fileName = connectorModel.getName() + ".ic";
        return Path.of(this.directoryPath, new String[0]).resolve(fileName);
    }

    private void validateSerializedModel(MuleConnectorModel connectorModel) throws MojoExecutionException {
        Path serializedModelPath = this.getMuleSerializedIcPath(connectorModel);
        MuleModelDeserializer serializer = new MuleModelDeserializer();
        try (FileReader serializedModelReader = new FileReader(serializedModelPath.toFile());){
            serializer.deserialize((Map)new Gson().fromJson((Reader)serializedModelReader, Object.class));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failures while validating deserialization:" + ex.getMessage(), ex);
        }
    }

    private Writer getFileWriter(Path filePath) throws MojoExecutionException {
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            return new FileWriter(filePath.toFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was an error while creating parent directories of %s", filePath), (Exception)e);
        }
    }

    @Generated
    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    @Generated
    public void setMuleArtifactFile(String muleArtifactFile) {
        this.muleArtifactFile = muleArtifactFile;
    }
}

