/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.validator.rules;

import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.HashSet;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class MuleParameterUniqueNameRule
extends Rule<ObjectType> {
    public MuleParameterUniqueNameRule() {
        super(ObjectType.class);
    }

    protected void validate(Validatable<ObjectType> validatable, ValidationContext ctx) {
        ObjectType type = (ObjectType)validatable.getElement();
        HashSet<String> names = new HashSet<String>();
        for (KeyValuePairType keyValuePairType : type.getProperties()) {
            String propertyName = NameUtils.sanitizeName((String)keyValuePairType.getKeyName());
            if (names.contains(propertyName)) {
                ctx.addError(keyValuePairType.getLocation(), "Object type has properties clashing with the same name: " + propertyName, "connector");
            }
            names.add(propertyName);
        }
    }

    public boolean appliesTo(Validatable<ObjectType> validatable) {
        return super.appliesTo(validatable) && (validatable.hasContext(ValidatableType.INPUT) || validatable.hasContext(ValidatableType.OUTPUT));
    }
}

