/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.validator.rules;

import com.mulesoft.connectivity.validation.Validatable;
import com.mulesoft.connectivity.validation.ValidatableType;
import com.mulesoft.connectivity.validation.ValidationContext;
import com.mulesoft.connectivity.validation.rules.Rule;
import java.util.Arrays;
import java.util.Set;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;

public class MuleUnionRule
extends Rule<UnionType> {
    public MuleUnionRule() {
        super(UnionType.class);
    }

    protected void validate(Validatable<UnionType> validatable, ValidationContext ctx) {
        UnionType type = (UnionType)validatable.getElement();
        if (!this.isEnumType(type) && this.isTopLevel(validatable)) {
            ctx.addError(validatable.getLocation(), "Unsupported union type: " + String.valueOf(type), "connector");
        }
    }

    private boolean isEnumType(UnionType type) {
        DWType[] types = type.unionOf();
        return Arrays.stream(types).allMatch(t -> {
            StringType st;
            return t instanceof StringType && (st = (StringType)t).getValue().isPresent();
        }) || Arrays.stream(types).allMatch(t -> {
            NumberType nt;
            return t instanceof NumberType && (nt = (NumberType)t).getValue().isPresent();
        });
    }

    private boolean isTopLevel(Validatable<UnionType> validatable) {
        Set types;
        Validatable current = validatable;
        for (int i = 0; i < 2; ++i) {
            if (current.getParent() == null) {
                return false;
            }
            current = current.getParent();
        }
        if (current.getElement() instanceof SimpleReferenceType) {
            if (current.getParent() == null) {
                return false;
            }
            current = current.getParent();
        }
        return (types = current.getTypes()).contains(ValidatableType.INPUT) || types.contains(ValidatableType.OUTPUT);
    }
}

