/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.deserialize.type;

import com.mulesoft.connectivity.mule.persistence.deserialize.MetadataTypeLoader;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.AbstractTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.utils.SerializerUtils;
import com.mulesoft.connectivity.mule.persistence.metadata.FormatAnnotation;
import com.mulesoft.connectivity.mule.persistence.metadata.MetadataFormatType;
import java.util.Map;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.model.NumberType;

public class NumberTypeDeserializer
extends AbstractTypeDeserializer<NumberType, NumberTypeBuilder> {
    NumberTypeDeserializer() {
        super(BaseTypeBuilder::numberType);
    }

    @Override
    public NumberTypeBuilder buildType(Map<?, ?> typeObject, BaseTypeBuilder baseBuilder, MetadataTypeLoader typeLoader) {
        NumberTypeBuilder numberTypeBuilder = (NumberTypeBuilder)this.supplier.get(baseBuilder);
        this.parseAnnotations(typeObject, numberTypeBuilder);
        return numberTypeBuilder;
    }

    private void parseAnnotations(Map<?, ?> typeObject, NumberTypeBuilder numberTypeBuilder) {
        SerializerUtils.getAnnotations(typeObject, true).forEach(annotation -> {
            if ("format".equals(annotation.getName())) {
                String value = ((FormatAnnotation)annotation).getValue();
                switch (MetadataFormatType.fromValue(value)) {
                    case INT_32: {
                        numberTypeBuilder.integer().range((Number)Integer.MIN_VALUE, (Number)Integer.MAX_VALUE);
                        break;
                    }
                    case INT_64: {
                        numberTypeBuilder.integer().range((Number)Long.MIN_VALUE, (Number)Long.MAX_VALUE);
                        break;
                    }
                    case INTEGER: {
                        numberTypeBuilder.integer();
                        break;
                    }
                    case FLOAT: {
                        numberTypeBuilder.range((Number)Float.valueOf(Float.MIN_VALUE), (Number)Float.valueOf(Float.MAX_VALUE));
                        break;
                    }
                    case DOUBLE: {
                        numberTypeBuilder.range((Number)Double.MIN_VALUE, (Number)Double.MAX_VALUE);
                        break;
                    }
                }
            } else {
                numberTypeBuilder.with(annotation);
            }
        });
    }
}

