/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.deserialize.type;

import com.mulesoft.connectivity.mule.persistence.deserialize.MetadataTypeLoader;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.AbstractTypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.utils.SerializerUtils;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.AttributeFieldTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectKeyBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectType;

public class ObjectTypeDeserializer
extends AbstractTypeDeserializer<ObjectType, ObjectTypeBuilder> {
    ObjectTypeDeserializer() {
        super(BaseTypeBuilder::objectType);
    }

    @Override
    public ObjectTypeBuilder buildType(Map<?, ?> typeObject, BaseTypeBuilder baseBuilder, MetadataTypeLoader typeLoader) {
        ObjectTypeBuilder objectTypeBuilder = (ObjectTypeBuilder)this.supplier.get(baseBuilder);
        if (typeObject.containsKey("ordered")) {
            objectTypeBuilder.ordered(Boolean.parseBoolean((String)typeObject.get("ordered")));
        }
        if (typeObject.containsKey("open")) {
            objectTypeBuilder.openWith(typeLoader.buildType(typeObject.get("open"), objectTypeBuilder.openWith()));
        }
        SerializerUtils.getAnnotations(typeObject).forEach(arg_0 -> ((ObjectTypeBuilder)objectTypeBuilder).with(arg_0));
        for (Object fieldObject : (List)typeObject.get("fields")) {
            Map field = (Map)fieldObject;
            ObjectFieldTypeBuilder fieldBuilder = objectTypeBuilder.addField();
            Map key = (Map)field.get("key");
            this.buildFieldKey(key, fieldBuilder, typeLoader);
            if (key.containsKey("required")) {
                fieldBuilder.required(Boolean.parseBoolean((String)key.get("required")));
            }
            if (key.containsKey("repeated")) {
                fieldBuilder.repeated(Boolean.parseBoolean((String)key.get("repeated")));
            }
            SerializerUtils.getAnnotations(key).forEach(arg_0 -> ((ObjectFieldTypeBuilder)fieldBuilder).withKeyAnnotation(arg_0));
            SerializerUtils.getAnnotations(field).forEach(arg_0 -> ((ObjectFieldTypeBuilder)fieldBuilder).with(arg_0));
            Object valueElement = field.get("model");
            if (valueElement instanceof Map) {
                Map valueObject = (Map)valueElement;
                fieldBuilder.value(typeLoader.buildType(valueObject, new BaseTypeBuilder(SerializerUtils.VOLATILE_FORMAT)));
                continue;
            }
            fieldBuilder.value(typeLoader.buildType(valueElement, fieldBuilder.value()));
        }
        return objectTypeBuilder;
    }

    private void buildFieldKey(Map<?, ?> key, ObjectFieldTypeBuilder fieldBuilder, MetadataTypeLoader typeLoader) {
        String keyName = (String)key.get("name");
        if (this.isPattern(key)) {
            fieldBuilder.key(Pattern.compile(keyName));
        } else {
            ObjectKeyBuilder keyBuilder = fieldBuilder.key(ObjectTypeDeserializer.parseKey(keyName));
            if (key.containsKey("attributes")) {
                this.parseAttributes(key, keyBuilder, typeLoader, SerializerUtils.VOLATILE_FORMAT);
            }
        }
    }

    private void parseAttributes(Map<?, ?> value, ObjectKeyBuilder objectKeyBuilder, MetadataTypeLoader typeLoader, MetadataFormat format) {
        for (Object attributeJsonElement : (List)value.get("attributes")) {
            AttributeFieldTypeBuilder attributeFieldTypeBuilder = objectKeyBuilder.addAttribute();
            Map attribute = (Map)attributeJsonElement;
            Map attributeKey = (Map)attribute.get("key");
            String attributeKeyName = (String)attributeKey.get("name");
            if (this.isPattern(attributeKey)) {
                attributeFieldTypeBuilder.pattern(Pattern.compile(attributeKeyName));
            } else {
                attributeFieldTypeBuilder.name(ObjectTypeDeserializer.parseKey(attributeKeyName));
            }
            if (attributeKey.containsKey("required")) {
                attributeFieldTypeBuilder.required(Boolean.parseBoolean((String)attributeKey.get("required")));
            }
            Map attributeModel = (Map)attribute.get("model");
            attributeFieldTypeBuilder.value(typeLoader.buildType(attributeModel, new BaseTypeBuilder(format)));
        }
    }

    static QName parseKey(String key) {
        int pos;
        if (key.charAt(0) == '{' && (pos = key.indexOf(125, 1)) != -1) {
            return new QName(key.substring(1, pos), key.substring(pos + 1));
        }
        return new QName(key);
    }

    private boolean isPattern(Object value) {
        if (value instanceof Map) {
            for (TypeAnnotation typeAnnotation : SerializerUtils.getAnnotations((Map)value)) {
                if (!typeAnnotation.getName().equals("pattern")) continue;
                return true;
            }
        }
        return false;
    }
}

