/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.deserialize.utils;

import com.mulesoft.connectivity.mule.persistence.deserialize.annotations.DefaultValueAnnotationDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.annotations.DescriptionAnnotationDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.annotations.EnumAnnotationDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.annotations.FormatAnnotationDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.annotations.LabelAnnotationDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.annotations.SemanticTermsAnnotationDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.annotations.TypeAliasAnnotationDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.annotations.TypeAnnotationDeserializer;
import com.mulesoft.connectivity.mule.persistence.metadata.FormatAnnotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;

public class SerializerUtils {
    private static final Map<String, TypeAnnotationDeserializer<? extends TypeAnnotation>> ANNOTATION_DESERIALIZERS = Stream.of(new DescriptionAnnotationDeserializer(), new LabelAnnotationDeserializer(), new SemanticTermsAnnotationDeserializer(), new DefaultValueAnnotationDeserializer(), new TypeAliasAnnotationDeserializer(), new FormatAnnotationDeserializer(), new EnumAnnotationDeserializer()).collect(Collectors.toMap(TypeAnnotationDeserializer::getKey, Function.identity()));
    public static final MetadataFormat VOLATILE_FORMAT = new MetadataFormat("", "id", new String[0]);

    private SerializerUtils() {
    }

    public static List<TypeAnnotation> getAnnotations(Map<?, ?> type) {
        return SerializerUtils.getAnnotations(type, false);
    }

    public static List<TypeAnnotation> getAnnotations(Map<?, ?> type, boolean isFormatEnabled) {
        Map annotations = (Map)type.get("annotations");
        if (annotations == null) {
            return Collections.emptyList();
        }
        return annotations.entrySet().stream().filter(annotation -> isFormatEnabled || !FormatAnnotation.class.getName().equals(annotation.getKey())).flatMap(annotation -> SerializerUtils.parseTypeAnnotation((String)annotation.getKey(), annotation.getValue()).stream()).collect(Collectors.toUnmodifiableList());
    }

    private static Optional<? extends TypeAnnotation> parseTypeAnnotation(String key, Object value) {
        TypeAnnotationDeserializer<? extends TypeAnnotation> typeAnnotationDeserializer = ANNOTATION_DESERIALIZERS.get(key);
        if (typeAnnotationDeserializer == null) {
            throw new UnsupportedOperationException("Don't know how to deserialize '" + key + "'");
        }
        return Optional.of(typeAnnotationDeserializer.create(value));
    }
}

