/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.model.connection;

import java.util.Objects;
import java.util.Optional;

public class HttpAuthenticationType {
    private final Type type;
    private final String subType;

    public HttpAuthenticationType(Type type, String subType) {
        this.type = Objects.requireNonNull(type, "'type' cannot be null");
        this.subType = subType;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<String> getSubType() {
        return Optional.ofNullable(this.subType);
    }

    public String toString() {
        return "HttpAuthenticationType{type=" + String.valueOf((Object)this.type) + ", subType='" + this.subType + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpAuthenticationType that = (HttpAuthenticationType)o;
        return this.type == that.type && Objects.equals(this.subType, that.subType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.subType});
    }

    public static enum Type {
        basic,
        bearer,
        apiKey,
        oauth2,
        custom;


        public static Type fromString(String type) {
            return switch (type) {
                case "basic" -> basic;
                case "bearer" -> bearer;
                case "apiKey" -> apiKey;
                case "oauth2" -> oauth2;
                case "custom" -> custom;
                default -> throw new IllegalArgumentException("Unsupported type: " + type);
            };
        }
    }
}

