/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.deserialize.loader;

import com.mulesoft.connectivity.mule.persistence.deserialize.MetadataTypeLoader;
import com.mulesoft.connectivity.mule.persistence.deserialize.ObjectTypeReferenceHandler;
import com.mulesoft.connectivity.mule.persistence.deserialize.loader.CatalogLoader;
import com.mulesoft.connectivity.mule.persistence.deserialize.loader.ExternalCatalogObjectTypeReferenceHandler;
import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleErrorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleOperationSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleSourceSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleValueProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.ApiKeyHttpAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleTestConnectionSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2AuthCodeAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2AuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2ClientCredentialsAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedContextReferenceVariable;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedObjectFieldSelector;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderArgument;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReference;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderReferences;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedTypeReferenceExpression;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.Category;

public class MuleModelDeserializer {
    private ObjectTypeReferenceHandler refHandler;

    public synchronized MuleConnectorSerializableModel deserialize(Map<?, ?> serialized) {
        Map jsonCatalog = this.requireProperty(serialized, "catalog", Map.class);
        Map<String, MetadataType> catalog = CatalogLoader.loadCatalog(jsonCatalog);
        this.refHandler = new ExternalCatalogObjectTypeReferenceHandler(catalog);
        MuleTestConnectionSerializableModel testConnection = this.deserializeTestConnection(this.requireProperty(serialized, "testConnection", Map.class));
        return ((MuleConnectorSerializableModel.Builder)MuleConnectorSerializableModel.builder().name(this.requireProperty(serialized, "name", String.class)).displayName(this.requireProperty(serialized, "displayName", String.class)).version(this.requireProperty(serialized, "version", String.class)).description(this.requireProperty(serialized, "description", String.class)).vendor(this.requireProperty(serialized, "vendor", String.class)).category(this.getCategoryFromString(this.requireProperty(serialized, "category", String.class))).connectionProviders(this.deserializeConnections(testConnection, (List)this.getProperty(serialized, "connections"))).testConnection(testConnection).operations(this.deserializeOperations((List)this.getProperty(serialized, "operations"))).sources(this.deserializeSources((List)this.getProperty(serialized, "sources"))).valueProviders(this.deserializeValueProviders((List)this.getProperty(serialized, "valueProviders"))).modelReference((String)this.getProperty(serialized, "modelReference"))).build();
    }

    private List<MuleOperationSerializableModel> deserializeOperations(List<Map<String, Object>> serializedOperations) {
        LinkedList<MuleOperationSerializableModel> result = new LinkedList<MuleOperationSerializableModel>();
        if (serializedOperations != null) {
            for (Map<String, Object> serializedOperation : serializedOperations) {
                MuleOperationSerializableModel muleOperationSerializableModel = ((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)((MuleOperationSerializableModel.Builder)MuleOperationSerializableModel.builder().name(serializedOperation.get("name").toString())).displayName(serializedOperation.get("displayName").toString())).inputType(this.deserializeMetadataType((Map)this.getProperty(serializedOperation, "inputType")))).outputType(this.deserializeMetadataType((Map)this.getProperty(serializedOperation, "outputType")))).errorOutputType(this.deserializeMetadataType((Map)this.getProperty(serializedOperation, "errorOutputType")))).errorModelList(this.deserializeErrorModels((List)this.getProperty(serializedOperation, "errorModelList")))).inputResolvedProviders(this.deserializeSerializedProviders((Map)this.getProperty(serializedOperation, "inputResolvedProviders")))).outputResolvedProviders(this.deserializeSerializedProviders((Map)this.getProperty(serializedOperation, "outputResolvedProviders")))).modelReference((String)this.getProperty(serializedOperation, "modelReference"))).isPaginated(this.requireProperty(serializedOperation, "isPaginated", Boolean.class))).build();
                result.add(muleOperationSerializableModel);
            }
        }
        return result;
    }

    private List<MuleSourceSerializableModel> deserializeSources(List<Map<String, Object>> serializedSources) {
        LinkedList<MuleSourceSerializableModel> result = new LinkedList<MuleSourceSerializableModel>();
        if (serializedSources != null) {
            for (Map<String, Object> serializedSource : serializedSources) {
                MuleSourceSerializableModel muleSourceSerializableModel = ((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)((MuleSourceSerializableModel.Builder)MuleSourceSerializableModel.builder().name(serializedSource.get("name").toString())).displayName(serializedSource.get("displayName").toString())).inputType(this.deserializeMetadataType((Map)this.getProperty(serializedSource, "inputType")))).outputType(this.deserializeMetadataType((Map)this.getProperty(serializedSource, "outputType")))).errorOutputType(this.deserializeMetadataType((Map)this.getProperty(serializedSource, "errorOutputType")))).errorModelList(this.deserializeErrorModels((List)this.getProperty(serializedSource, "errorModelList")))).inputResolvedProviders(this.deserializeSerializedProviders((Map)this.getProperty(serializedSource, "inputResolvedProviders")))).outputResolvedProviders(this.deserializeSerializedProviders((Map)this.getProperty(serializedSource, "outputResolvedProviders")))).modelReference((String)this.getProperty(serializedSource, "modelReference"))).isPaginated(this.requireProperty(serializedSource, "isPaginated", Boolean.class))).build();
                result.add(muleSourceSerializableModel);
            }
        }
        return result;
    }

    private Map<SerializedObjectFieldSelector, SerializedProviderReferences> deserializeSerializedProviders(Map<?, ?> providers) {
        if (providers == null) {
            return Map.of();
        }
        return providers.entrySet().stream().collect(Collectors.toMap(entry -> this.deserializeSerializedObjectFieldSelectorFromString((String)entry.getKey()), entry -> this.deserializeSerializedProviderReferences((Map)entry.getValue())));
    }

    private SerializedProviderReferences deserializeSerializedProviderReferences(Map<?, ?> providerRefs) {
        Object valueProviderRef = this.getProperty(providerRefs, "valueProviderReference");
        SerializedProviderReference valueProvider = valueProviderRef != null ? this.deserializeSerializedProviderReference((Map)valueProviderRef) : null;
        Object metadataProviderRef = this.getProperty(providerRefs, "metadataProviderReference");
        SerializedProviderReference metadataProvider = metadataProviderRef != null ? this.deserializeSerializedProviderReference((Map)metadataProviderRef) : null;
        return new SerializedProviderReferences(valueProvider, metadataProvider);
    }

    private SerializedProviderReference deserializeSerializedProviderReference(Map<?, ?> value) {
        return new SerializedProviderReference((String)this.getProperty(value, "name"), this.deserializeSerializedProviderArguments((List)this.getProperty(value, "arguments")));
    }

    private List<SerializedProviderArgument> deserializeSerializedProviderArguments(List<?> arguments) {
        if (arguments == null) {
            return List.of();
        }
        return arguments.stream().map(arg -> (Map)arg).map(this::deserializeSerializedProviderArgument).toList();
    }

    private SerializedProviderArgument deserializeSerializedProviderArgument(Map<?, ?> arg) {
        return new SerializedProviderArgument(this.deserializeSerializedObjectFieldSelector((Map)this.getProperty(arg, "parameterSelector")), this.deserializeSerializedTypeReferenceExpression((Map)this.getProperty(arg, "inputSelector")));
    }

    private SerializedObjectFieldSelector deserializeSerializedObjectFieldSelector(Map<?, ?> selector) {
        return new SerializedObjectFieldSelector((Boolean)this.getProperty(selector, "relative"), (String[])((List)this.getProperty(selector, "path")).toArray(String[]::new));
    }

    private SerializedObjectFieldSelector deserializeSerializedObjectFieldSelectorFromString(String key) {
        return SerializedObjectFieldSelector.create(key);
    }

    private SerializedTypeReferenceExpression deserializeSerializedTypeReferenceExpression(Map<?, ?> typeRef) {
        String name = (String)this.getProperty(typeRef, "name");
        if (name != null) {
            return new SerializedContextReferenceVariable(name);
        }
        boolean relative = (Boolean)this.getProperty(typeRef, "relative");
        String[] path = (String[])((List)this.getProperty(typeRef, "path")).toArray(String[]::new);
        return new SerializedObjectFieldSelector(relative, path);
    }

    private List<MuleValueProviderSerializableModel> deserializeValueProviders(List<Map<String, Object>> serializedValueProviders) {
        LinkedList<MuleValueProviderSerializableModel> result = new LinkedList<MuleValueProviderSerializableModel>();
        if (serializedValueProviders != null) {
            for (Map<String, Object> serializedValueProvider : serializedValueProviders) {
                MuleValueProviderSerializableModel muleValueProviderSerializableModel = ((MuleValueProviderSerializableModel.Builder)MuleValueProviderSerializableModel.builder().name(serializedValueProvider.get("name").toString()).inputType(this.deserializeMetadataType((Map)this.getProperty(serializedValueProvider, "inputType"))).errorOutputType(this.deserializeMetadataType((Map)this.getProperty(serializedValueProvider, "errorOutputType"))).modelReference((String)this.getProperty(serializedValueProvider, "modelReference"))).providedValueType(this.deserializeMetadataType((Map)this.getProperty(serializedValueProvider, "providedValueType"))).displayPropertiesType(this.deserializeMetadataType((Map)this.getProperty(serializedValueProvider, "displayPropertiesType"))).isPaginated(this.requireProperty(serializedValueProvider, "isPaginated", Boolean.class)).build();
                result.add(muleValueProviderSerializableModel);
            }
        }
        return result;
    }

    private List<MuleErrorSerializableModel> deserializeErrorModels(List<Map<?, ?>> serializedErrorModels) {
        LinkedList<MuleErrorSerializableModel> result = new LinkedList<MuleErrorSerializableModel>();
        if (serializedErrorModels != null) {
            for (Map<?, ?> serializedErrorModel : serializedErrorModels) {
                MuleErrorSerializableModel muleErrorSerializableModel = ((MuleErrorSerializableModel.Builder)MuleErrorSerializableModel.builder().kind((String)this.getProperty(serializedErrorModel, "kind")).categories((List)this.getProperty(serializedErrorModel, "categories")).errorType(this.deserializeMetadataType((Map)this.getProperty(serializedErrorModel, "errorType"))).modelReference((String)this.getProperty(serializedErrorModel, "modelReference"))).build();
                result.add(muleErrorSerializableModel);
            }
        }
        return result;
    }

    private MuleTestConnectionSerializableModel deserializeTestConnection(Map<?, ?> serialized) {
        if (serialized != null) {
            return ((MuleTestConnectionSerializableModel.Builder)MuleTestConnectionSerializableModel.builder().modelReference((String)this.getProperty(serialized, "modelReference"))).build();
        }
        return null;
    }

    private List<MuleConnectionProviderSerializableModel> deserializeConnections(MuleTestConnectionSerializableModel globalTestConnection, List<Map<String, Object>> serializedConnections) {
        LinkedList<MuleConnectionProviderSerializableModel> result = new LinkedList<MuleConnectionProviderSerializableModel>();
        if (serializedConnections != null) {
            for (Map<String, Object> serializedConnection : serializedConnections) {
                MuleTestConnectionSerializableModel testConnectionOverride = this.deserializeTestConnection((Map)this.getProperty(serializedConnection, "testConnection"));
                MuleTestConnectionSerializableModel effectiveTestConnection = testConnectionOverride != null ? testConnectionOverride : globalTestConnection;
                MuleConnectionProviderSerializableModel muleConnectionProviderSerializableModel = ((MuleConnectionProviderSerializableModel.Builder)MuleConnectionProviderSerializableModel.builder().inputType(this.deserializeMetadataType((Map)this.getProperty(serializedConnection, "inputType"))).testConnection(effectiveTestConnection).authenticationType(this.deserializeAuthenticationType(this.requireProperty(serializedConnection, "authenticationType", Map.class))).hasExtensions(Boolean.TRUE.equals(this.getProperty(serializedConnection, "hasExtensions"))).modelReference((String)this.getProperty(serializedConnection, "modelReference"))).name((String)this.getProperty(serializedConnection, "name")).build();
                result.add(muleConnectionProviderSerializableModel);
            }
        }
        return result;
    }

    private HttpAuthenticationType deserializeAuthenticationType(Map<?, ?> authenticationType) {
        String type = this.requireProperty(authenticationType, "type", String.class);
        String subType = (String)this.getProperty(authenticationType, "subType");
        HttpAuthenticationType.Type httpAuthType = HttpAuthenticationType.Type.fromString(type);
        switch (httpAuthType) {
            case oauth2: {
                OAuth2AuthenticationType.GrantType oAuthType = OAuth2AuthenticationType.GrantType.fromString(subType);
                String refreshUrl = this.requireProperty(authenticationType, "refreshUrl", String.class);
                List scopes = this.requireProperty(authenticationType, "scopes", List.class);
                String tokenUrl = this.requireProperty(authenticationType, "tokenUrl", String.class);
                switch (oAuthType) {
                    case clientCredentials: {
                        return new OAuth2ClientCredentialsAuthenticationType(refreshUrl, scopes, tokenUrl);
                    }
                    case authorizationCode: {
                        String authorizationUrl = this.requireProperty(authenticationType, "authorizationUrl", String.class);
                        return new OAuth2AuthCodeAuthenticationType(refreshUrl, scopes, authorizationUrl, tokenUrl);
                    }
                }
                throw new NotImplementedException("AuthType: " + type + " and subType: " + subType + " is not yet supported");
            }
            case apiKey: {
                String in = this.requireProperty(authenticationType, "in", String.class);
                String name = this.requireProperty(authenticationType, "name", String.class);
                return new ApiKeyHttpAuthenticationType(subType, ApiKeyHttpAuthenticationType.In.fromString(in), name);
            }
            case basic: 
            case bearer: {
                return new HttpAuthenticationType(httpAuthType, subType);
            }
        }
        throw new NotImplementedException("AuthType: " + type + " is not yet supported");
    }

    private MetadataType deserializeMetadataType(Map<?, ?> serializedMetadataType) {
        MetadataTypeLoader metadataTypeLoader = new MetadataTypeLoader(this.refHandler);
        Optional<MetadataType> optionalMetadataType = metadataTypeLoader.load(serializedMetadataType);
        if (optionalMetadataType.isEmpty()) {
            throw new IllegalStateException("Unable to load type from " + String.valueOf(serializedMetadataType));
        }
        return optionalMetadataType.get();
    }

    private Category getCategoryFromString(String categoryStr) {
        return Category.valueOf((String)categoryStr.toUpperCase());
    }

    private <T> T getProperty(Map<?, ?> map, String property) {
        return (T)map.get(property);
    }

    private <T> T requireProperty(Map<?, ?> map, String property, Class<T> expectedClass) {
        Object object = map.get(property);
        if (object == null) {
            throw new NullPointerException("Missing property '" + property + "' while deserializing." + String.valueOf(map));
        }
        if (!expectedClass.isInstance(object)) {
            throw new IllegalArgumentException("Expecting property '" + property + "' while deserializing to be " + expectedClass.getSimpleName() + ", but was " + object.getClass().getSimpleName());
        }
        return expectedClass.cast(object);
    }
}

