/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.deserialize;

import com.mulesoft.connectivity.mule.persistence.deserialize.ObjectTypeReferenceHandler;
import com.mulesoft.connectivity.mule.persistence.deserialize.exception.MetadataDeserializingException;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.MetadataTypeDeserializerProvider;
import com.mulesoft.connectivity.mule.persistence.deserialize.type.TypeDeserializer;
import com.mulesoft.connectivity.mule.persistence.deserialize.utils.MetadataTypeConstants;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

public class MetadataTypeLoader {
    private static final String MISSING_METADATA_FORMAT_ATTRIBUTE = "MetadataFormat object is malformed. '%s' property is required";
    private static final String UNSUPPORTED_METADATA_TYPE_FOUND = "Unsupported MetadataType '%s' found.";
    private final MetadataTypeDeserializerProvider typeDeserializerProvider;
    private final ObjectTypeReferenceHandler referenceHandler;
    private Deque<TypeBuilder<? extends MetadataType>> typeBuilderStack;
    private Deque<MetadataFormat> metadataFormatStack;

    public MetadataTypeLoader(ObjectTypeReferenceHandler referenceHandler) {
        this.referenceHandler = referenceHandler;
        this.typeDeserializerProvider = new MetadataTypeDeserializerProvider();
    }

    public Optional<MetadataType> load(Map<?, ?> typeObject) {
        return this.load(typeObject, new ArrayDeque<TypeBuilder<? extends MetadataType>>(), new ArrayDeque<MetadataFormat>()).map(TypeBuilder::build);
    }

    protected Optional<TypeBuilder<? extends MetadataType>> load(Map<?, ?> typeObject, Deque<TypeBuilder<? extends MetadataType>> builderStack, Deque<MetadataFormat> formatStack) {
        try {
            this.typeBuilderStack = builderStack;
            this.metadataFormatStack = formatStack;
            Object typeElement = typeObject.get("type");
            if (typeElement instanceof String && ((String)typeElement).startsWith("@ref:")) {
                return this.referenceHandler.readReference((String)typeElement).map(tb -> tb);
            }
            MetadataFormat format = this.buildMetadataFormat(typeObject.get("format"));
            this.metadataFormatStack.push(format);
            BaseTypeBuilder baseTypeBuilder = BaseTypeBuilder.create((MetadataFormat)format);
            return Optional.of(this.buildType(typeObject, baseTypeBuilder));
        }
        catch (Exception e) {
            throw new MetadataDeserializingException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TypeBuilder<?> buildType(Object metadataTypeElement, BaseTypeBuilder baseBuilder) {
        TypeBuilder typeBuilder;
        this.typeBuilderStack.push((TypeBuilder<? extends MetadataType>)baseBuilder);
        if (metadataTypeElement instanceof Map) {
            Map typeObject = (Map)metadataTypeElement;
            MetadataFormat currentMetadataFormat = this.updateMetadataFormat(typeObject, baseBuilder, this.metadataFormatStack.peek());
            this.metadataFormatStack.push(currentMetadataFormat);
            String type = (String)typeObject.get("type");
            Optional<TypeDeserializer<? extends MetadataType>> typeDeserializer = this.typeDeserializerProvider.get(type);
            if (typeDeserializer.isPresent()) {
                typeBuilder = typeDeserializer.get().buildType(typeObject, baseBuilder, this);
            } else {
                typeBuilder = this.referenceHandler.readReference(type).orElse(null);
                if (typeBuilder == null) {
                    throw new MetadataDeserializingException(String.format(UNSUPPORTED_METADATA_TYPE_FOUND, type));
                }
            }
            this.metadataFormatStack.pop();
        } else {
            if (!(metadataTypeElement instanceof String)) throw new IllegalStateException("Cannot build type from " + metadataTypeElement.getClass().getName());
            String typeReference = (String)metadataTypeElement;
            if (!typeReference.startsWith("#")) throw new MetadataDeserializingException(String.format(UNSUPPORTED_METADATA_TYPE_FOUND, typeReference));
            typeBuilder = (TypeBuilder)this.typeBuilderStack.stream().skip(typeReference.split("/").length).findFirst().orElseThrow();
        }
        this.typeBuilderStack.pop();
        return typeBuilder;
    }

    private MetadataFormat updateMetadataFormat(Map<?, ?> typeObject, BaseTypeBuilder baseBuilder, MetadataFormat currentFormat) {
        MetadataFormat metadataFormat = currentFormat;
        if (typeObject.containsKey("format")) {
            Object formatJsonElement = typeObject.get("format");
            metadataFormat = this.buildMetadataFormat(formatJsonElement);
        }
        baseBuilder.withFormat(metadataFormat);
        return metadataFormat;
    }

    private MetadataFormat buildMetadataFormat(Object formatElement) {
        MetadataFormat metadataFormat;
        if (formatElement instanceof Map) {
            Map formatObject = (Map)formatElement;
            ArrayList<String> validMimeTypesList = new ArrayList<String>();
            String label = null;
            if (!formatObject.containsKey("id")) {
                throw new MetadataDeserializingException(String.format(MISSING_METADATA_FORMAT_ATTRIBUTE, "id"));
            }
            String id = (String)formatObject.get("id");
            if (formatObject.containsKey("label")) {
                label = (String)formatObject.get("label");
            }
            for (Object validMimeTypes : (List)formatObject.get("validMimeTypes")) {
                validMimeTypesList.add((String)validMimeTypes);
            }
            metadataFormat = new MetadataFormat(label, id, validMimeTypesList.toArray(new String[0]));
        } else {
            String formatId = (String)formatElement;
            int formatIndex = MetadataTypeConstants.COMMON_METADATA_FORMATS.indexOf(new MetadataFormat("label", formatId, new String[0]));
            metadataFormat = MetadataTypeConstants.COMMON_METADATA_FORMATS.get(formatIndex);
        }
        return metadataFormat;
    }
}

