/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.model;

import com.mulesoft.connectivity.mule.persistence.model.SerializableModel;
import java.util.List;
import java.util.Objects;
import org.mule.metadata.api.model.MetadataType;

public class MuleErrorSerializableModel
extends SerializableModel {
    protected final String kind;
    protected final List<String> categories;
    protected final MetadataType errorType;

    protected MuleErrorSerializableModel(String kind, List<String> categories, MetadataType errorType, String modelReference) {
        super(modelReference);
        this.kind = kind;
        this.categories = Objects.requireNonNullElse(categories, List.of());
        this.errorType = errorType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKind() {
        return this.kind;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public MetadataType getErrorType() {
        return this.errorType;
    }

    public String toString() {
        return "MuleErrorSerializableModel{kind='" + this.getKind() + "', categories=" + String.valueOf(this.getCategories()) + "', errorType='" + String.valueOf(this.getErrorType()) + "', modelReference='" + this.modelReference + "}";
    }

    public static class Builder
    extends SerializableModel.Builder<Builder> {
        private String kind;
        private List<String> categories;
        private MetadataType errorType;

        private Builder() {
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            return this;
        }

        public Builder errorType(MetadataType errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public MuleErrorSerializableModel build() {
            return new MuleErrorSerializableModel(this.kind, this.categories, this.errorType, this.modelReference);
        }
    }
}

