/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.utils;

import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.MediaType;

public class HttpResponseBuilder {
    private static final String AUTH_HEADER_NAME = "Location";
    private final HttpResponse httpResponse = HttpResponse.response();

    HttpResponseBuilder() {
    }

    public HttpResponseBuilder withStatusCode(int statusCode) {
        this.httpResponse.withStatusCode(Integer.valueOf(statusCode));
        return this;
    }

    public HttpResponseBuilder withReasonPhrase(String reasonPhrase) {
        this.httpResponse.withReasonPhrase(reasonPhrase);
        return this;
    }

    public HttpResponseBuilder withBody(String body) {
        this.httpResponse.withBody(body);
        return this;
    }

    public HttpResponseBuilder withBodyAndMediaType(String body, MediaType mediaType) {
        this.httpResponse.withBody(body);
        this.httpResponse.withBody(body, mediaType);
        return this;
    }

    public HttpResponseBuilder withBody(JsonBody body) {
        this.httpResponse.withBody((BodyWithContentType)body);
        return this;
    }

    public HttpResponseBuilder withContentType(MediaType mediaType) {
        this.httpResponse.withContentType(mediaType);
        return this;
    }

    public HttpResponseBuilder withHeader(String name, String value) {
        this.httpResponse.withHeader(name, new String[]{value});
        return this;
    }

    public HttpResponseBuilder withOAuthCallback(String callbackPath, String authCode) {
        return this.withHeader(AUTH_HEADER_NAME, "http://localhost:8081" + callbackPath + "?code=" + authCode);
    }

    public HttpResponse build() {
        return this.httpResponse;
    }
}

