/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.utils;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Base64;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.JsonBody;

public class MockServerUtils {
    private MockServerUtils() {
    }

    public static int findAvailablePort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            socket.setReuseAddress(true);
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioException) {
                throw new RuntimeException("Cannot obtain a free socket port: " + ioException.getMessage());
            }
        }
        socket.close();
        return n;
    }

    public static String getBasicAuthHeader(String username, String password) {
        return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
    }

    public static String getBearerAuthHeader(String token) {
        return "Bearer " + token;
    }

    public static String getApiKeyAuthHeader(String apiKey) {
        return apiKey;
    }

    public static JsonBody createJsonBody(String json) {
        return new JsonBody(json, MatchType.ONLY_MATCHING_FIELDS);
    }
}

