/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.utils;

import com.mulesoft.connectivity.utils.MockServerUtils;
import java.util.Map;
import org.mockserver.model.Body;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonBody;

public class HttpRequestBuilder {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String TOKEN = "token";
    private static final String APIKEY = "apiKey";
    private static final String AUTH_HEADER_NAME = "authorization";
    private static final String APIKEY_AUTH_HEADER_NAME = "x-api-key";
    private final HttpRequest httpRequest;

    HttpRequestBuilder(String method, String path) {
        this.httpRequest = HttpRequest.request().withMethod(method).withPath(path);
    }

    public HttpRequestBuilder withHeader(String name, String value) {
        this.httpRequest.withHeader(name, new String[]{value});
        return this;
    }

    public HttpRequestBuilder withBasicAuth(String username, String password) {
        return this.withHeader(AUTH_HEADER_NAME, MockServerUtils.getBasicAuthHeader(username, password));
    }

    public HttpRequestBuilder withQueryParameter(String name, String ... values) {
        this.httpRequest.withQueryStringParameter(name, values);
        return this;
    }

    public HttpRequestBuilder withBasicAuth(Map<String, String> authParameterMap) {
        return this.withBasicAuth(authParameterMap.get(USERNAME), authParameterMap.get(PASSWORD));
    }

    public HttpRequestBuilder withBearerAuth(String token) {
        return this.withHeader(AUTH_HEADER_NAME, MockServerUtils.getBearerAuthHeader(token));
    }

    public HttpRequestBuilder withBearerAuth(Map<String, String> authParameterMap) {
        return this.withBearerAuth(authParameterMap.get(TOKEN));
    }

    public HttpRequestBuilder withApiKeyAuth(String apiKey) {
        return this.withHeader(APIKEY_AUTH_HEADER_NAME, MockServerUtils.getApiKeyAuthHeader(apiKey));
    }

    public HttpRequestBuilder withApiKeyAuth(Map<String, String> authParameterMap) {
        return this.withApiKeyAuth(authParameterMap.get(APIKEY));
    }

    public HttpRequestBuilder withOAuthCc(String token) {
        return this.withHeader(AUTH_HEADER_NAME, MockServerUtils.getBearerAuthHeader(token));
    }

    public HttpRequestBuilder withOAuthAc(String token) {
        return this.withHeader(AUTH_HEADER_NAME, MockServerUtils.getBearerAuthHeader(token));
    }

    public HttpRequestBuilder withBody(JsonBody jsonBody) {
        this.httpRequest.withBody((Body)jsonBody);
        return this;
    }

    public HttpRequestBuilder withQueryStringParameter(String key, String value) {
        this.httpRequest.withQueryStringParameter(key, new String[]{value});
        return this;
    }

    public HttpRequest build() {
        return this.httpRequest;
    }
}

