/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mockServer;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.Configuration;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;
import org.mockserver.verify.VerificationTimes;
import org.slf4j.event.Level;

public class HttpMockServer {
    public static final int MAX_PORT_NUMBER = 65535;
    private final int port;
    private MockServerClient mockServerClient;

    public HttpMockServer(int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Port value out of range: " + port);
        }
        this.port = port;
    }

    public void startServer() {
        this.checkPortAvailability(this.port);
        this.mockServerClient = ClientAndServer.startClientAndServer((Configuration)Configuration.configuration().logLevel(Level.INFO), (Integer[])new Integer[]{this.port});
    }

    public void stopServer() {
        this.mockServerClient.stop();
    }

    public void reset() {
        this.mockServerClient.reset();
    }

    public boolean isServerRunning() {
        return this.mockServerClient.hasStarted();
    }

    public int getPort() {
        return this.mockServerClient.getPort();
    }

    public String configureHttpRequestResponse(HttpRequest httpRequest, HttpResponse httpResponse) {
        Expectation[] expectations = this.mockServerClient.when((RequestDefinition)httpRequest).respond(httpResponse);
        return expectations[0].getId();
    }

    public String configureHttpRequestResponseWithTimes(HttpRequest httpRequest, HttpResponse httpResponse, Times times) {
        Expectation[] expectations = this.mockServerClient.when((RequestDefinition)httpRequest, times).respond(httpResponse);
        return expectations[0].getId();
    }

    public void verifyExpectationTriggered(String expectationId, int verificationTimes) {
        this.mockServerClient.verify(expectationId, VerificationTimes.exactly((int)verificationTimes));
    }

    private void checkPortAvailability(int port) {
        try (ServerSocket socket = new ServerSocket(port);){
            socket.setReuseAddress(true);
        }
        catch (BindException e) {
            throw new RuntimeException("Port " + port + " is already in use: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

